/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.editors.swing.particles;

import com.jmex.editors.swing.particles.InfluenceEditPanel;
import com.jmex.editors.swing.widget.SphericalUnitVectorPanel;
import com.jmex.editors.swing.widget.ValuePanel;
import com.jmex.effects.particles.SimpleParticleInfluenceFactory;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VortexInfluencePanel
extends InfluenceEditPanel {
    private static final long serialVersionUID = 1L;
    private JComboBox vortexTypeBox;
    private ValuePanel vortexRadiusPanel = new ValuePanel("Radius: ", "", 0.0f, Float.MAX_VALUE, 1.0f);
    private ValuePanel vortexHeightPanel = new ValuePanel("Height: ", "", -3.4028235E38f, Float.MAX_VALUE, 1.0f);
    private ValuePanel vortexStrengthPanel = new ValuePanel("Strength: ", "", 0.0f, Float.MAX_VALUE, 0.1f);
    private ValuePanel vortexDivergencePanel = new ValuePanel("Divergence: ", "", -90.0f, 90.0f, 1.0f);
    private SphericalUnitVectorPanel vortexDirectionPanel = new SphericalUnitVectorPanel();
    private JCheckBox vortexRandomBox;

    public VortexInfluencePanel() {
        this.setLayout(new GridBagLayout());
        this.initPanel();
    }

    private void initPanel() {
        this.vortexTypeBox = new JComboBox<String>(new String[]{"Cylinder", "Torus"});
        this.vortexTypeBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = VortexInfluencePanel.this.vortexTypeBox.getSelectedIndex();
                ((SimpleParticleInfluenceFactory.BasicVortex)VortexInfluencePanel.this.getEdittedInfluence()).setType(n);
                VortexInfluencePanel.this.vortexRadiusPanel.setEnabled(n == 1);
                VortexInfluencePanel.this.vortexHeightPanel.setEnabled(n == 1);
            }
        });
        this.vortexRadiusPanel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ((SimpleParticleInfluenceFactory.BasicVortex)VortexInfluencePanel.this.getEdittedInfluence()).setRadius(VortexInfluencePanel.this.vortexRadiusPanel.getFloatValue());
            }
        });
        this.vortexHeightPanel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ((SimpleParticleInfluenceFactory.BasicVortex)VortexInfluencePanel.this.getEdittedInfluence()).setHeight(VortexInfluencePanel.this.vortexHeightPanel.getFloatValue());
            }
        });
        this.vortexDirectionPanel.setBorder(this.createTitledBorder(" DIRECTION "));
        this.vortexDirectionPanel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ((SimpleParticleInfluenceFactory.BasicVortex)VortexInfluencePanel.this.getEdittedInfluence()).getAxis().setDirection(VortexInfluencePanel.this.vortexDirectionPanel.getValue());
            }
        });
        this.vortexStrengthPanel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ((SimpleParticleInfluenceFactory.BasicVortex)VortexInfluencePanel.this.getEdittedInfluence()).setStrength(VortexInfluencePanel.this.vortexStrengthPanel.getFloatValue());
            }
        });
        this.vortexDivergencePanel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ((SimpleParticleInfluenceFactory.BasicVortex)VortexInfluencePanel.this.getEdittedInfluence()).setDivergence(VortexInfluencePanel.this.vortexDivergencePanel.getFloatValue() * ((float)Math.PI / 180));
            }
        });
        this.vortexRandomBox = new JCheckBox(new AbstractAction("Vary Randomly"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ((SimpleParticleInfluenceFactory.BasicVortex)VortexInfluencePanel.this.getEdittedInfluence()).setRandom(VortexInfluencePanel.this.vortexRandomBox.isSelected());
            }
        });
        this.setBorder(this.createTitledBorder(" VORTEX PARAMETERS "));
        this.add((Component)this.createBoldLabel("Type:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.vortexRadiusPanel, new GridBagConstraints(0, 1, 2, 1, 0.5, 0.0, 10, 2, new Insets(5, 5, 10, 5), 0, 0));
        this.add((Component)this.vortexHeightPanel, new GridBagConstraints(0, 2, 2, 1, 0.5, 0.0, 10, 2, new Insets(5, 5, 10, 5), 0, 0));
        this.add((Component)this.vortexTypeBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.vortexStrengthPanel, new GridBagConstraints(0, 3, 2, 1, 0.5, 0.0, 10, 2, new Insets(5, 5, 10, 5), 0, 0));
        this.add((Component)this.vortexDivergencePanel, new GridBagConstraints(0, 4, 2, 1, 0.5, 0.0, 10, 2, new Insets(5, 5, 10, 5), 0, 0));
        this.add((Component)this.vortexDirectionPanel, new GridBagConstraints(0, 5, 2, 1, 0.5, 0.0, 10, 2, new Insets(5, 5, 10, 5), 0, 0));
        this.add((Component)this.vortexRandomBox, new GridBagConstraints(0, 6, 2, 1, 0.5, 0.0, 10, 0, new Insets(5, 5, 10, 5), 0, 0));
    }

    public void updateWidgets() {
        SimpleParticleInfluenceFactory.BasicVortex basicVortex = (SimpleParticleInfluenceFactory.BasicVortex)this.getEdittedInfluence();
        this.vortexTypeBox.setSelectedIndex(basicVortex.getType());
        this.vortexHeightPanel.setValue(basicVortex.getHeight());
        this.vortexHeightPanel.setEnabled(basicVortex.getType() == 1);
        this.vortexRadiusPanel.setValue(basicVortex.getRadius());
        this.vortexRadiusPanel.setEnabled(basicVortex.getType() == 1);
        this.vortexDirectionPanel.setValue(basicVortex.getAxis().getDirection());
        this.vortexStrengthPanel.setValue(basicVortex.getStrength());
        this.vortexDivergencePanel.setValue(basicVortex.getDivergence() * 57.295776f);
        this.vortexRandomBox.setSelected(basicVortex.isRandom());
    }
}

