/*
 * Decompiled with CFR 0.152.
 */
package com.jme.math;

import com.jme.math.FastMath;
import com.jme.math.Matrix3f;
import com.jme.math.Vector3f;
import java.util.logging.Logger;

public class Eigen3f {
    private static final Logger logger = Logger.getLogger(Eigen3f.class.getName());
    float[] eigenValues = new float[3];
    Vector3f[] eigenVectors = new Vector3f[3];
    static final double ONE_THIRD_DOUBLE = 0.3333333333333333;
    static final double ROOT_THREE_DOUBLE = Math.sqrt(3.0);

    public Eigen3f() {
    }

    public Eigen3f(Matrix3f matrix3f) {
        this.calculateEigen(matrix3f);
    }

    public void calculateEigen(Matrix3f matrix3f) {
        this.eigenVectors[0] = new Vector3f();
        this.eigenVectors[1] = new Vector3f();
        this.eigenVectors[2] = new Vector3f();
        Matrix3f matrix3f2 = new Matrix3f(matrix3f);
        float f = this.scaleMatrix(matrix3f2);
        double[] dArray = new double[3];
        this.computeRoots(matrix3f2, dArray);
        this.eigenValues[0] = (float)dArray[0];
        this.eigenValues[1] = (float)dArray[1];
        this.eigenValues[2] = (float)dArray[2];
        float[] fArray = new float[3];
        Vector3f[] vector3fArray = new Vector3f[]{new Vector3f(), new Vector3f(), new Vector3f()};
        for (int i = 0; i < 3; ++i) {
            Matrix3f matrix3f3 = new Matrix3f(matrix3f2);
            matrix3f3.m00 -= this.eigenValues[i];
            matrix3f3.m11 -= this.eigenValues[i];
            matrix3f3.m22 -= this.eigenValues[i];
            float[] fArray2 = new float[]{fArray[i]};
            if (!this.positiveRank(matrix3f3, fArray2, vector3fArray[i])) {
                if (f > 1.0f) {
                    int n = 0;
                    while (n < 3) {
                        int n2 = n++;
                        this.eigenValues[n2] = this.eigenValues[n2] * f;
                    }
                }
                this.eigenVectors[0].set(Vector3f.UNIT_X);
                this.eigenVectors[1].set(Vector3f.UNIT_Y);
                this.eigenVectors[2].set(Vector3f.UNIT_Z);
                return;
            }
            fArray[i] = fArray2[0];
        }
        float f2 = fArray[0];
        int n = 0;
        if (fArray[1] > f2) {
            f2 = fArray[1];
            n = 1;
        }
        if (fArray[2] > f2) {
            n = 2;
        }
        switch (n) {
            case 0: {
                vector3fArray[0].normalizeLocal();
                this.computeVectors(matrix3f2, vector3fArray[0], 1, 2, 0);
                break;
            }
            case 1: {
                vector3fArray[1].normalizeLocal();
                this.computeVectors(matrix3f2, vector3fArray[1], 2, 0, 1);
                break;
            }
            case 2: {
                vector3fArray[2].normalizeLocal();
                this.computeVectors(matrix3f2, vector3fArray[2], 0, 1, 2);
            }
        }
        if (f > 1.0f) {
            n = 0;
            while (n < 3) {
                int n3 = n++;
                this.eigenValues[n3] = this.eigenValues[n3] * f;
            }
        }
    }

    private float scaleMatrix(Matrix3f matrix3f) {
        float f = FastMath.abs(matrix3f.m00);
        float f2 = FastMath.abs(matrix3f.m01);
        if (f2 > f) {
            f = f2;
        }
        if ((f2 = FastMath.abs(matrix3f.m02)) > f) {
            f = f2;
        }
        if ((f2 = FastMath.abs(matrix3f.m11)) > f) {
            f = f2;
        }
        if ((f2 = FastMath.abs(matrix3f.m12)) > f) {
            f = f2;
        }
        if ((f2 = FastMath.abs(matrix3f.m22)) > f) {
            f = f2;
        }
        if (f > 1.0f) {
            float f3 = 1.0f / f;
            matrix3f.multLocal(f3);
        }
        return f;
    }

    private void computeVectors(Matrix3f matrix3f, Vector3f vector3f, int n, int n2, int n3) {
        float f;
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f();
        Vector3f.generateComplementBasis(vector3f2, vector3f3, vector3f);
        Vector3f vector3f4 = matrix3f.mult(vector3f2);
        float f2 = this.eigenValues[n3] - vector3f2.dot(vector3f4);
        float f3 = vector3f3.dot(vector3f4);
        float f4 = this.eigenValues[n3] - vector3f3.dot(matrix3f.mult(vector3f3));
        float f5 = FastMath.abs(f2);
        boolean bl = false;
        float f6 = FastMath.abs(f3);
        if (f6 > f5) {
            f5 = f6;
        }
        if ((f6 = FastMath.abs(f4)) > f5) {
            f5 = f6;
            bl = true;
        }
        if (f5 >= 1.0E-4f) {
            if (!bl) {
                f = FastMath.invSqrt(f2 * f2 + f3 * f3);
                vector3f2.mult(f3 *= f, this.eigenVectors[n3]).addLocal(vector3f3.mult(f2 *= f));
            } else {
                f = FastMath.invSqrt(f4 * f4 + f3 * f3);
                vector3f2.mult(f4 *= f, this.eigenVectors[n3]).addLocal(vector3f3.mult(f3 *= f));
            }
        } else {
            this.eigenVectors[n3] = !bl ? vector3f3 : vector3f2;
        }
        Vector3f vector3f5 = vector3f.cross(this.eigenVectors[n3]);
        matrix3f.mult(vector3f, vector3f4);
        f2 = this.eigenValues[n] - vector3f.dot(vector3f4);
        f3 = vector3f5.dot(vector3f4);
        f4 = this.eigenValues[n] - vector3f5.dot(matrix3f.mult(vector3f5));
        f5 = FastMath.abs(f2);
        bl = false;
        f6 = FastMath.abs(f3);
        if (f6 > f5) {
            f5 = f6;
        }
        if ((f6 = FastMath.abs(f4)) > f5) {
            f5 = f6;
            bl = true;
        }
        if (f5 >= 1.0E-4f) {
            if (!bl) {
                f = FastMath.invSqrt(f2 * f2 + f3 * f3);
                this.eigenVectors[n] = vector3f.mult(f3 *= f).add(vector3f5.mult(f2 *= f));
            } else {
                f = FastMath.invSqrt(f4 * f4 + f3 * f3);
                this.eigenVectors[n] = vector3f.mult(f4 *= f).add(vector3f5.mult(f3 *= f));
            }
        } else if (!bl) {
            this.eigenVectors[n].set(vector3f5);
        } else {
            this.eigenVectors[n].set(vector3f);
        }
        this.eigenVectors[n3].cross(this.eigenVectors[n], this.eigenVectors[n2]);
    }

    private boolean positiveRank(Matrix3f matrix3f, float[] fArray, Vector3f vector3f) {
        fArray[0] = -1.0f;
        int n = -1;
        for (int i = 0; i < 3; ++i) {
            for (int j = i; j < 3; ++j) {
                float f = FastMath.abs(matrix3f.get(i, j));
                if (!(f > fArray[0])) continue;
                fArray[0] = f;
                n = i;
            }
        }
        vector3f.set(matrix3f.getRow(n));
        return fArray[0] >= 1.0E-4f;
    }

    private void computeRoots(Matrix3f matrix3f, double[] dArray) {
        double d;
        double d2;
        double d3 = matrix3f.m00;
        double d4 = matrix3f.m01;
        double d5 = matrix3f.m02;
        double d6 = matrix3f.m11;
        double d7 = matrix3f.m12;
        double d8 = matrix3f.m22;
        double d9 = d3 * d6 * d8 + 2.0 * d4 * d5 * d7 - d3 * d7 * d7 - d6 * d5 * d5 - d8 * d4 * d4;
        double d10 = d3 * d6 - d4 * d4 + d3 * d8 - d5 * d5 + d6 * d8 - d7 * d7;
        double d11 = d3 + d6 + d8;
        double d12 = d11 * 0.3333333333333333;
        double d13 = (d10 - d11 * d12) * 0.3333333333333333;
        if (d13 > 0.0) {
            d13 = 0.0;
        }
        if ((d2 = (d = 0.5 * (d9 + d12 * (2.0 * d12 * d12 - d10))) * d + d13 * d13 * d13) > 0.0) {
            d2 = 0.0;
        }
        double d14 = Math.sqrt(-d13);
        double d15 = Math.atan2(Math.sqrt(-d2), d) * 0.3333333333333333;
        double d16 = Math.cos(d15);
        double d17 = Math.sin(d15);
        double d18 = d12 + 2.0 * d14 * d16;
        double d19 = d12 - d14 * (d16 + ROOT_THREE_DOUBLE * d17);
        double d20 = d12 - d14 * (d16 - ROOT_THREE_DOUBLE * d17);
        if (d19 >= d18) {
            dArray[0] = d18;
            dArray[1] = d19;
        } else {
            dArray[0] = d19;
            dArray[1] = d18;
        }
        if (d20 >= dArray[1]) {
            dArray[2] = d20;
        } else {
            dArray[2] = dArray[1];
            if (d20 >= dArray[0]) {
                dArray[1] = d20;
            } else {
                dArray[1] = dArray[0];
                dArray[0] = d20;
            }
        }
    }

    public static void main(String[] stringArray) {
        int n;
        Matrix3f matrix3f = new Matrix3f(2.0f, 1.0f, 1.0f, 1.0f, 2.0f, 1.0f, 1.0f, 1.0f, 2.0f);
        Eigen3f eigen3f = new Eigen3f(matrix3f);
        logger.info("eigenvalues = ");
        for (n = 0; n < 3; ++n) {
            logger.info(eigen3f.getEigenValue(n) + " ");
        }
        logger.info("eigenvectors = ");
        for (n = 0; n < 3; ++n) {
            Vector3f vector3f = eigen3f.getEigenVector(n);
            logger.info(vector3f.toString());
            matrix3f.setColumn(n, vector3f);
        }
        logger.info(matrix3f.toString());
    }

    public float getEigenValue(int n) {
        return this.eigenValues[n];
    }

    public Vector3f getEigenVector(int n) {
        return this.eigenVectors[n];
    }

    public float[] getEigenValues() {
        return this.eigenValues;
    }

    public Vector3f[] getEigenVectors() {
        return this.eigenVectors;
    }
}

