/*
 * Decompiled with CFR 0.152.
 */
package com.jme.math;

import com.jme.math.Eigen3f;
import com.jme.math.FastMath;
import com.jme.math.Matrix3f;
import com.jme.math.Vector3f;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import com.jme.util.geom.BufferUtils;
import java.io.IOException;
import java.io.Serializable;
import java.nio.FloatBuffer;

public class Line
implements Serializable,
Savable {
    private static final long serialVersionUID = 1L;
    private Vector3f origin;
    private Vector3f direction;
    private static final Vector3f compVec1 = new Vector3f();
    private static final Vector3f compVec2 = new Vector3f();
    private static final Matrix3f compMat1 = new Matrix3f();
    private static final Eigen3f compEigen1 = new Eigen3f();

    public Line() {
        this.origin = new Vector3f();
        this.direction = new Vector3f();
    }

    public Line(Vector3f vector3f, Vector3f vector3f2) {
        this.origin = vector3f;
        this.direction = vector3f2;
    }

    public Vector3f getOrigin() {
        return this.origin;
    }

    public void setOrigin(Vector3f vector3f) {
        this.origin = vector3f;
    }

    public Vector3f getDirection() {
        return this.direction;
    }

    public void setDirection(Vector3f vector3f) {
        this.direction = vector3f;
    }

    public float distanceSquared(Vector3f vector3f) {
        vector3f.subtract(this.origin, compVec1);
        float f = this.direction.dot(compVec1);
        this.origin.add(this.direction.mult(f, compVec2), compVec2);
        compVec2.subtract(vector3f, compVec1);
        return compVec1.lengthSquared();
    }

    public float distance(Vector3f vector3f) {
        return FastMath.sqrt(this.distanceSquared(vector3f));
    }

    public void orthogonalLineFit(FloatBuffer floatBuffer) {
        if (floatBuffer == null) {
            return;
        }
        floatBuffer.rewind();
        int n = floatBuffer.remaining() / 3;
        BufferUtils.populateFromBuffer(this.origin, floatBuffer, 0);
        for (int i = 1; i < n; ++i) {
            BufferUtils.populateFromBuffer(compVec1, floatBuffer, i);
            this.origin.addLocal(compVec1);
        }
        this.origin.multLocal(1.0f / (float)n);
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        floatBuffer.rewind();
        for (int i = 0; i < n; ++i) {
            BufferUtils.populateFromBuffer(compVec1, floatBuffer, i);
            compVec1.subtract(this.origin, compVec2);
            f += Line.compVec2.x * Line.compVec2.x;
            f2 += Line.compVec2.x * Line.compVec2.y;
            f3 += Line.compVec2.x * Line.compVec2.z;
            f4 += Line.compVec2.y * Line.compVec2.y;
            f5 += Line.compVec2.y * Line.compVec2.z;
            f6 += Line.compVec2.z * Line.compVec2.z;
        }
        Line.compMat1.m00 = f4 + f6;
        Line.compMat1.m01 = -f2;
        Line.compMat1.m02 = -f3;
        Line.compMat1.m10 = -f2;
        Line.compMat1.m11 = f + f6;
        Line.compMat1.m12 = -f5;
        Line.compMat1.m20 = -f3;
        Line.compMat1.m21 = -f5;
        Line.compMat1.m22 = f + f4;
        compEigen1.calculateEigen(compMat1);
        this.direction = compEigen1.getEigenVector(0);
    }

    public Vector3f random() {
        return this.random(null);
    }

    public Vector3f random(Vector3f vector3f) {
        if (vector3f == null) {
            vector3f = new Vector3f();
        }
        float f = (float)Math.random();
        vector3f.x = this.origin.x * (1.0f - f) + this.direction.x * f;
        vector3f.y = this.origin.y * (1.0f - f) + this.direction.y * f;
        vector3f.z = this.origin.z * (1.0f - f) + this.direction.z * f;
        return vector3f;
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.origin, "origin", Vector3f.ZERO);
        outputCapsule.write(this.direction, "direction", Vector3f.ZERO);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.origin = (Vector3f)inputCapsule.readSavable("origin", Vector3f.ZERO.clone());
        this.direction = (Vector3f)inputCapsule.readSavable("direction", Vector3f.ZERO.clone());
    }

    public Class getClassTag() {
        return this.getClass();
    }
}

