/*
 * Decompiled with CFR 0.152.
 */
package com.jme.math;

import com.jme.math.FastMath;
import com.jme.math.Vector3f;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.logging.Logger;

public class Vector2f
implements Externalizable,
Savable {
    private static final Logger logger = Logger.getLogger(Vector2f.class.getName());
    private static final long serialVersionUID = 1L;
    public float x;
    public float y;

    public Vector2f(float f, float f2) {
        this.x = f;
        this.y = f2;
    }

    public Vector2f() {
        this.y = 0.0f;
        this.x = 0.0f;
    }

    public Vector2f(Vector2f vector2f) {
        this.x = vector2f.x;
        this.y = vector2f.y;
    }

    public Vector2f set(float f, float f2) {
        this.x = f;
        this.y = f2;
        return this;
    }

    public Vector2f set(Vector2f vector2f) {
        this.x = vector2f.x;
        this.y = vector2f.y;
        return this;
    }

    public Vector2f add(Vector2f vector2f) {
        if (null == vector2f) {
            logger.warning("Provided vector is null, null returned.");
            return null;
        }
        return new Vector2f(this.x + vector2f.x, this.y + vector2f.y);
    }

    public Vector2f addLocal(Vector2f vector2f) {
        if (null == vector2f) {
            logger.warning("Provided vector is null, null returned.");
            return null;
        }
        this.x += vector2f.x;
        this.y += vector2f.y;
        return this;
    }

    public Vector2f addLocal(float f, float f2) {
        this.x += f;
        this.y += f2;
        return this;
    }

    public Vector2f add(Vector2f vector2f, Vector2f vector2f2) {
        if (null == vector2f) {
            logger.warning("Provided vector is null, null returned.");
            return null;
        }
        if (vector2f2 == null) {
            vector2f2 = new Vector2f();
        }
        vector2f2.x = this.x + vector2f.x;
        vector2f2.y = this.y + vector2f.y;
        return vector2f2;
    }

    public float dot(Vector2f vector2f) {
        if (null == vector2f) {
            logger.warning("Provided vector is null, 0 returned.");
            return 0.0f;
        }
        return this.x * vector2f.x + this.y * vector2f.y;
    }

    public Vector3f cross(Vector2f vector2f) {
        return new Vector3f(0.0f, 0.0f, this.x * vector2f.y - this.y * vector2f.x);
    }

    public void interpolate(Vector2f vector2f, float f) {
        this.x = (1.0f - f) * this.x + f * vector2f.x;
        this.y = (1.0f - f) * this.y + f * vector2f.y;
    }

    public void interpolate(Vector2f vector2f, Vector2f vector2f2, float f) {
        this.x = (1.0f - f) * vector2f.x + f * vector2f2.x;
        this.y = (1.0f - f) * vector2f.y + f * vector2f2.y;
    }

    public float length() {
        return FastMath.sqrt(this.lengthSquared());
    }

    public float lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public Vector2f mult(float f) {
        return new Vector2f(this.x * f, this.y * f);
    }

    public Vector2f multLocal(float f) {
        this.x *= f;
        this.y *= f;
        return this;
    }

    public Vector2f multLocal(Vector2f vector2f) {
        if (null == vector2f) {
            logger.warning("Provided vector is null, null returned.");
            return null;
        }
        this.x *= vector2f.x;
        this.y *= vector2f.y;
        return this;
    }

    public Vector2f mult(float f, Vector2f vector2f) {
        if (null == vector2f) {
            vector2f = new Vector2f();
        }
        vector2f.x = this.x * f;
        vector2f.y = this.y * f;
        return vector2f;
    }

    public Vector2f divide(float f) {
        return new Vector2f(this.x / f, this.y / f);
    }

    public Vector2f divideLocal(float f) {
        this.x /= f;
        this.y /= f;
        return this;
    }

    public Vector2f negate() {
        return new Vector2f(-this.x, -this.y);
    }

    public Vector2f negateLocal() {
        this.x = -this.x;
        this.y = -this.y;
        return this;
    }

    public Vector2f subtract(Vector2f vector2f) {
        return this.subtract(vector2f, null);
    }

    public Vector2f subtract(Vector2f vector2f, Vector2f vector2f2) {
        if (vector2f2 == null) {
            vector2f2 = new Vector2f();
        }
        vector2f2.x = this.x - vector2f.x;
        vector2f2.y = this.y - vector2f.y;
        return vector2f2;
    }

    public Vector2f subtractLocal(Vector2f vector2f) {
        if (null == vector2f) {
            logger.warning("Provided vector is null, null returned.");
            return null;
        }
        this.x -= vector2f.x;
        this.y -= vector2f.y;
        return this;
    }

    public Vector2f subtractLocal(float f, float f2) {
        this.x -= f;
        this.y -= f2;
        return this;
    }

    public Vector2f normalize() {
        float f = this.length();
        if (f != 0.0f) {
            return this.divide(f);
        }
        return this.divide(1.0f);
    }

    public Vector2f normalizeLocal() {
        float f = this.length();
        if (f != 0.0f) {
            return this.divideLocal(f);
        }
        return this.divideLocal(1.0f);
    }

    public float smallestAngleBetween(Vector2f vector2f) {
        float f = this.dot(vector2f);
        float f2 = FastMath.acos(f);
        return f2;
    }

    public float angleBetween(Vector2f vector2f) {
        float f = FastMath.atan2(vector2f.y, vector2f.x) - FastMath.atan2(this.y, this.x);
        return f;
    }

    public float getAngle() {
        return -FastMath.atan2(this.y, this.x);
    }

    public void zero() {
        this.y = 0.0f;
        this.x = 0.0f;
    }

    public int hashCode() {
        int n = 37;
        n += 37 * n + Float.floatToIntBits(this.x);
        n += 37 * n + Float.floatToIntBits(this.y);
        return n;
    }

    public Vector2f clone() {
        return new Vector2f(this.x, this.y);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Vector2f) || object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        Vector2f vector2f = (Vector2f)object;
        if (Float.compare(this.x, vector2f.x) != 0) {
            return false;
        }
        return Float.compare(this.y, vector2f.y) == 0;
    }

    public String toString() {
        return "com.jme.math.Vector2f [X=" + this.x + ", Y=" + this.y + "]";
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.x = objectInput.readFloat();
        this.y = objectInput.readFloat();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeFloat(this.x);
        objectOutput.writeFloat(this.y);
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.x, "x", 0.0f);
        outputCapsule.write(this.y, "y", 0.0f);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.x = inputCapsule.readFloat("x", 0.0f);
        this.y = inputCapsule.readFloat("y", 0.0f);
    }

    public Class getClassTag() {
        return this.getClass();
    }

    public void rotateAroundOrigin(float f, boolean bl) {
        if (bl) {
            f = -f;
        }
        float f2 = FastMath.cos(f) * this.x - FastMath.sin(f) * this.y;
        float f3 = FastMath.sin(f) * this.x + FastMath.cos(f) * this.y;
        this.x = f2;
        this.y = f3;
    }
}

