/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene;

import com.jme.app.SimpleGame;
import com.jme.intersection.CollisionResults;
import com.jme.renderer.ColorRGBA;
import com.jme.renderer.Renderer;
import com.jme.scene.Geometry;
import com.jme.scene.Spatial;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;
import com.jme.util.TextureManager;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import java.io.IOException;
import java.util.Stack;

public class Text
extends Geometry {
    private static final long serialVersionUID = 1L;
    private StringBuffer text;
    private ColorRGBA textColor = new ColorRGBA();
    public RenderState[] states = new RenderState[17];
    private static TextureState defaultFontTextureState;
    public static final String DEFAULT_FONT = "com/jme/app/defaultfont.tga";

    public Text() {
    }

    public Text(String string, String string2) {
        super(string);
        this.setCullMode(3);
        this.text = new StringBuffer(string2);
        this.setRenderQueueMode(4);
    }

    public void print(String string) {
        this.text.replace(0, this.text.length(), string);
    }

    public void print(StringBuffer stringBuffer) {
        this.text.setLength(0);
        this.text.append(stringBuffer);
    }

    public StringBuffer getText() {
        return this.text;
    }

    public void draw(Renderer renderer) {
        if (!renderer.isProcessingQueue() && renderer.checkAndAdd(this)) {
            return;
        }
        super.draw(renderer);
        renderer.draw(this);
    }

    public void setTextColor(ColorRGBA colorRGBA) {
        this.textColor = colorRGBA;
    }

    public ColorRGBA getTextColor() {
        return this.textColor;
    }

    public void findCollisions(Spatial spatial, CollisionResults collisionResults) {
    }

    public boolean hasCollision(Spatial spatial, boolean bl) {
        return false;
    }

    public float getWidth() {
        float f = 10.0f * (float)this.text.length() * this.worldScale.x;
        return f;
    }

    public float getHeight() {
        float f = 16.0f * this.worldScale.y;
        return f;
    }

    public static Text createDefaultTextLabel(String string) {
        return Text.createDefaultTextLabel(string, "");
    }

    public static Text createDefaultTextLabel(String string, String string2) {
        Text text = new Text(string, string2);
        text.setCullMode(3);
        text.setRenderState(Text.getDefaultFontTextureState());
        text.setRenderState(Text.getFontAlpha());
        return text;
    }

    private static AlphaState getFontAlpha() {
        AlphaState alphaState = DisplaySystem.getDisplaySystem().getRenderer().createAlphaState();
        alphaState.setBlendEnabled(true);
        alphaState.setSrcFunction(4);
        alphaState.setDstFunction(5);
        return alphaState;
    }

    public static final void resetFontTexture() {
        if (defaultFontTextureState != null) {
            defaultFontTextureState.deleteAll(true);
        }
    }

    protected void applyRenderState(Stack[] stackArray) {
        for (int i = 0; i < stackArray.length; ++i) {
            this.states[i] = stackArray[i].size() > 0 ? ((RenderState)stackArray[i].peek()).extract(stackArray[i], this) : Renderer.defaultStateList[i];
        }
    }

    private static TextureState getDefaultFontTextureState() {
        if (defaultFontTextureState == null) {
            defaultFontTextureState = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
            defaultFontTextureState.setTexture(TextureManager.loadTexture(SimpleGame.class.getClassLoader().getResource(DEFAULT_FONT), 6, 1, -2, 1.0f, true));
            defaultFontTextureState.setEnabled(true);
        }
        return defaultFontTextureState;
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.text.toString(), "textString", "");
        outputCapsule.write(this.textColor, "textColor", new ColorRGBA());
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.text = new StringBuffer(inputCapsule.readString("textString", ""));
        this.textColor = (ColorRGBA)inputCapsule.readSavable("textColor", new ColorRGBA());
    }
}

