/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.shape;

import com.jme.bounding.BoundingVolume;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Node;
import com.jme.scene.shape.Arrow;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import java.io.IOException;

public class AxisRods
extends Node {
    private static final long serialVersionUID = 1L;
    protected static final ColorRGBA xAxisColor = new ColorRGBA(1.0f, 0.0f, 0.0f, 0.4f);
    protected static final ColorRGBA yAxisColor = new ColorRGBA(0.0f, 1.0f, 0.0f, 0.25f);
    protected static final ColorRGBA zAxisColor = new ColorRGBA(0.0f, 0.0f, 1.0f, 0.4f);
    protected float length;
    protected float width;
    protected boolean rightHanded;
    protected Arrow xAxis;
    protected Arrow yAxis;
    protected Arrow zAxis;

    public AxisRods() {
    }

    public AxisRods(String string) {
        this(string, true, 1.0f);
    }

    public AxisRods(String string, boolean bl, float f) {
        this(string, bl, f, f * 0.125f);
    }

    public AxisRods(String string, boolean bl, float f, float f2) {
        super(string);
        this.length = f;
        this.width = f2;
        this.rightHanded = bl;
        this.setLightCombineMode(0);
        this.setTextureCombineMode(0);
        this.buildAxis();
    }

    protected void buildAxis() {
        this.xAxis = new Arrow("xAxis", this.length, this.width);
        this.xAxis.setSolidColor(xAxisColor);
        this.xAxis.getLocalRotation().fromAngles(0.0f, 0.0f, -1.5707964f);
        this.xAxis.getLocalTranslation().addLocal(this.length * 0.5f, 0.0f, 0.0f);
        this.attachChild(this.xAxis);
        this.yAxis = new Arrow("yAxis", this.length, this.width);
        this.yAxis.setSolidColor(yAxisColor);
        this.yAxis.getLocalTranslation().addLocal(0.0f, this.length * 0.5f, 0.0f);
        this.attachChild(this.yAxis);
        this.zAxis = new Arrow("zAxis", this.length, this.width);
        this.zAxis.setSolidColor(zAxisColor);
        if (this.rightHanded) {
            this.zAxis.getLocalRotation().fromAngles(1.5707964f, 0.0f, 0.0f);
            this.zAxis.getLocalTranslation().addLocal(0.0f, 0.0f, this.length * 0.5f);
        } else {
            this.zAxis.getLocalRotation().fromAngles(-1.5707964f, 0.0f, 0.0f);
            this.zAxis.getLocalTranslation().addLocal(0.0f, 0.0f, -this.length * 0.5f);
        }
        this.attachChild(this.zAxis);
    }

    public void setModelBound(BoundingVolume boundingVolume) {
        this.xAxis.setModelBound(boundingVolume);
        this.yAxis.setModelBound(boundingVolume);
        this.zAxis.setModelBound(boundingVolume);
    }

    public void updateModelBound() {
        this.xAxis.updateModelBound();
        this.yAxis.updateModelBound();
        this.zAxis.updateModelBound();
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.length, "length", 1.0f);
        outputCapsule.write(this.width, "width", 0.125f);
        outputCapsule.write(this.rightHanded, "rightHanded", true);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.length = inputCapsule.readFloat("length", 1.0f);
        this.width = inputCapsule.readFloat("width", 0.125f);
        this.rightHanded = inputCapsule.readBoolean("rightHanded", true);
        this.buildAxis();
    }

    public float getLength() {
        return this.length;
    }

    public void setLength(float f) {
        this.length = f;
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float f) {
        this.width = f;
    }
}

