/*
 * Decompiled with CFR 0.152.
 */
package com.jme.util;

import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import com.jme.util.resource.ResourceLocatorTool;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;

public final class TextureKey
implements Savable {
    protected URL location = null;
    protected boolean flipped;
    protected int code = Integer.MAX_VALUE;
    protected int imageType = -1;
    protected String fileType;

    public TextureKey() {
    }

    public TextureKey(URL uRL, boolean bl, int n) {
        this.location = uRL;
        this.flipped = bl;
        this.imageType = n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TextureKey)) {
            return false;
        }
        TextureKey textureKey = (TextureKey)object;
        if (this.location == null ? textureKey.location != null : !this.location.equals(textureKey.location)) {
            return false;
        }
        if (this.flipped != textureKey.flipped) {
            return false;
        }
        if (this.imageType != textureKey.imageType) {
            return false;
        }
        if (this.fileType == null && textureKey.fileType != null) {
            return false;
        }
        return this.fileType == null || this.fileType.equals(textureKey.fileType);
    }

    public int hashCode() {
        if (this.code == Integer.MAX_VALUE) {
            this.code = 37;
            if (this.location != null) {
                this.code += 37 * this.location.hashCode();
            }
            if (this.fileType != null) {
                this.code += 37 * this.fileType.hashCode();
            }
            this.code += 37 * this.imageType;
            this.code += 37 * (this.flipped ? 1 : 0);
        }
        return this.code;
    }

    public void resetHashCode() {
        this.code = Integer.MAX_VALUE;
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        if (this.location != null) {
            outputCapsule.write(this.location.getProtocol(), "protocol", null);
            outputCapsule.write(this.location.getHost(), "host", null);
            outputCapsule.write(this.location.getFile(), "file", null);
        }
        outputCapsule.write(this.flipped, "flipped", false);
        outputCapsule.write(this.imageType, "imageType", -1);
        outputCapsule.write(this.fileType, "fileType", null);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        String string = inputCapsule.readString("protocol", null);
        String string2 = inputCapsule.readString("host", null);
        String string3 = inputCapsule.readString("file", null);
        if (string3 != null) {
            this.location = ResourceLocatorTool.locateResource("texture", URLDecoder.decode(string3, "UTF-8"));
        }
        if (this.location == null && string != null && string2 != null && string3 != null) {
            this.location = new URL(string, string2, string3);
        }
        this.flipped = inputCapsule.readBoolean("flipped", false);
        this.imageType = inputCapsule.readInt("imageType", -1);
        this.fileType = inputCapsule.readString("fileType", null);
    }

    public int getImageType() {
        return this.imageType;
    }

    public void setImageType(int n) {
        this.imageType = n;
    }

    public Class getClassTag() {
        return this.getClass();
    }

    public boolean isFlipped() {
        return this.flipped;
    }

    public void setFlipped(boolean bl) {
        this.flipped = bl;
    }

    public URL getLocation() {
        return this.location;
    }

    public void setLocation(URL uRL) {
        this.location = uRL;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String string) {
        this.fileType = string;
    }

    public String toString() {
        String string = "tkey: loc:" + this.location + " flip: " + this.flipped + " code: " + this.hashCode() + " imageType: " + this.imageType + " fileType: " + this.fileType;
        return string;
    }
}

