/*
 * Decompiled with CFR 0.152.
 */
package com.jme.util.lwjgl;

import com.jme.util.Timer;
import java.util.logging.Logger;
import org.lwjgl.Sys;

public class LWJGLTimer
extends Timer {
    private static final Logger logger = Logger.getLogger(LWJGLTimer.class.getName());
    private long lastFrameDiff;
    private long oldTime;
    private float lastTPF;
    private float lastFPS;
    public static int TIMER_SMOOTHNESS = 32;
    private long[] tpf;
    private int smoothIndex;
    private static final long timerRez = Sys.getTimerResolution();
    private static final float invTimerRez = 1.0f / (float)timerRez;
    private static float invTimerRezSmooth;
    private long startTime;
    private boolean allSmooth = false;

    public LWJGLTimer() {
        this.reset();
        logger.info("Timer resolution: " + timerRez + " ticks per second");
    }

    public void reset() {
        this.lastFrameDiff = 0L;
        this.lastFPS = 0.0f;
        this.lastTPF = 0.0f;
        this.oldTime = -1L;
        this.startTime = Sys.getTime();
        this.tpf = new long[TIMER_SMOOTHNESS];
        this.smoothIndex = TIMER_SMOOTHNESS - 1;
        invTimerRezSmooth = 1.0f / (float)(timerRez * (long)TIMER_SMOOTHNESS);
        int n = this.tpf.length;
        while (--n >= 0) {
            this.tpf[n] = -1L;
        }
    }

    public long getTime() {
        return Sys.getTime() - this.startTime;
    }

    public long getResolution() {
        return timerRez;
    }

    public float getFrameRate() {
        return this.lastFPS;
    }

    public float getTimePerFrame() {
        return this.lastTPF;
    }

    public void update() {
        long l = Sys.getTime();
        long l2 = this.oldTime;
        this.oldTime = l;
        if (l2 == -1L) {
            this.lastTPF = 0.016666668f;
            this.lastFPS = 1.0f / this.lastTPF;
            return;
        }
        long l3 = l - l2;
        long l4 = this.lastFrameDiff;
        if (l4 > 0L && l3 > l4 * 100L) {
            l3 = l4 * 100L;
        }
        this.lastFrameDiff = l3;
        this.tpf[this.smoothIndex] = l3;
        --this.smoothIndex;
        if (this.smoothIndex < 0) {
            this.smoothIndex = this.tpf.length - 1;
        }
        this.lastTPF = 0.0f;
        if (!this.allSmooth) {
            int n = 0;
            int n2 = this.tpf.length;
            while (--n2 >= 0) {
                if (this.tpf[n2] == -1L) continue;
                this.lastTPF += (float)this.tpf[n2];
                ++n;
            }
            if (n == this.tpf.length) {
                this.allSmooth = true;
            }
            this.lastTPF *= invTimerRez / (float)n;
        } else {
            int n = this.tpf.length;
            while (--n >= 0) {
                if (this.tpf[n] == -1L) continue;
                this.lastTPF += (float)this.tpf[n];
            }
            this.lastTPF *= invTimerRezSmooth;
        }
        if (this.lastTPF < 1.1920929E-7f) {
            this.lastTPF = 1.1920929E-7f;
        }
        this.lastFPS = 1.0f / this.lastTPF;
    }

    public String toString() {
        String string = super.toString();
        string = string + "\nTime: " + this.oldTime;
        string = string + "\nFPS: " + this.getFrameRate();
        return string;
    }
}

