/*
 * Decompiled with CFR 0.152.
 */
package com.jme.util.resource;

import com.jme.util.resource.ResourceLocator;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResourceLocatorTool {
    private static final Logger logger = Logger.getLogger(ResourceLocatorTool.class.getName());
    public static final String TYPE_TEXTURE = "texture";
    public static final String TYPE_MODEL = "model";
    public static final String TYPE_PARTICLE = "particle";
    public static final String TYPE_AUDIO = "audio";
    public static final String TYPE_SHADER = "shader";
    private static final Map<String, ArrayList<ResourceLocator>> locatorMap = new HashMap<String, ArrayList<ResourceLocator>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URL locateResource(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        Map<String, ArrayList<ResourceLocator>> map = locatorMap;
        synchronized (map) {
            ArrayList<ResourceLocator> arrayList = locatorMap.get(string);
            if (arrayList != null) {
                int n = arrayList.size();
                while (--n >= 0) {
                    ResourceLocator resourceLocator = arrayList.get(n);
                    URL uRL = resourceLocator.locateResource(string2);
                    if (uRL == null) continue;
                    return uRL;
                }
            }
            try {
                URL uRL = ResourceLocatorTool.class.getResource(string2);
                if (uRL != null) {
                    return uRL;
                }
            }
            catch (Exception exception) {
                logger.logp(Level.WARNING, ResourceLocatorTool.class.getName(), "locateResource(String, String)", exception.getMessage(), exception);
            }
            logger.warning("Unable to locate: " + string2);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addResourceLocator(String string, ResourceLocator resourceLocator) {
        if (resourceLocator == null) {
            return;
        }
        Map<String, ArrayList<ResourceLocator>> map = locatorMap;
        synchronized (map) {
            ArrayList<ResourceLocator> arrayList = locatorMap.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList();
                locatorMap.put(string, arrayList);
            }
            if (!arrayList.contains(resourceLocator)) {
                arrayList.add(resourceLocator);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeResourceLocator(String string, ResourceLocator resourceLocator) {
        Map<String, ArrayList<ResourceLocator>> map = locatorMap;
        synchronized (map) {
            ArrayList<ResourceLocator> arrayList = locatorMap.get(string);
            if (arrayList == null) {
                return false;
            }
            return arrayList.remove(resourceLocator);
        }
    }
}

