/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.audio.openal;

import com.jme.math.Vector3f;
import com.jmex.audio.AudioBuffer;
import com.jmex.audio.AudioSystem;
import com.jmex.audio.AudioTrack;
import com.jmex.audio.openal.OpenALAudioBuffer;
import com.jmex.audio.openal.OpenALPropertyTool;
import com.jmex.audio.openal.OpenALSource;
import com.jmex.audio.openal.OpenALSystem;
import com.jmex.audio.player.MemoryAudioPlayer;
import java.util.logging.Logger;
import org.lwjgl.openal.AL10;

public class OpenALMemoryAudioPlayer
extends MemoryAudioPlayer {
    private static final Logger logger = Logger.getLogger(OpenALMemoryAudioPlayer.class.getName());
    private OpenALSource source;
    private boolean isPaused = false;

    public OpenALMemoryAudioPlayer(AudioBuffer audioBuffer, AudioTrack audioTrack) {
        super(audioBuffer, audioTrack);
    }

    public void init() {
    }

    public void cleanup() {
    }

    public boolean isPlaying() {
        return this.source != null && this.source.getState() == 4114;
    }

    public boolean isActive() {
        return this.source != null && (this.source.getState() == 4114 || this.source.getState() == 4115);
    }

    public boolean isStopped() {
        return this.source != null && this.source.getState() == 4116;
    }

    public void pause() {
        this.isPaused = true;
        AL10.alSourcePause((int)this.source.getId());
        this.setPauseTime(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play() {
        OpenALMemoryAudioPlayer openALMemoryAudioPlayer = this;
        synchronized (openALMemoryAudioPlayer) {
            if (this.isPaused) {
                this.isPaused = false;
                AL10.alSourcePlay((int)this.source.getId());
                this.setStartTime(this.getStartTime() + System.currentTimeMillis() - this.getPauseTime());
                return;
            }
            this.source = ((OpenALSystem)AudioSystem.getSystem()).getNextFreeSource();
            if (this.source == null) {
                return;
            }
            this.source.setTrack(this.getTrack());
            this.applyTrackProperties();
            AL10.alSource3f((int)this.source.getId(), (int)4100, (float)0.0f, (float)0.0f, (float)0.0f);
            AL10.alSource3f((int)this.source.getId(), (int)4102, (float)0.0f, (float)0.0f, (float)0.0f);
            AL10.alSource3f((int)this.source.getId(), (int)4101, (float)0.0f, (float)0.0f, (float)0.0f);
            AL10.alSourcei((int)this.source.getId(), (int)514, (int)(this.getTrack().isRelative() ? 1 : 0));
            AL10.alSourcei((int)this.source.getId(), (int)4105, (int)((OpenALAudioBuffer)this.getBuffer()).getId());
            AL10.alSourcePlay((int)this.source.getId());
            this.setStartTime(System.currentTimeMillis());
        }
    }

    public void applyTrackProperties() {
        OpenALPropertyTool.applyProperties(this, this.source);
        if (this.source != null) {
            AL10.alSourcei((int)this.source.getId(), (int)4103, (int)(this.isLoop() ? 1 : 0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        OpenALMemoryAudioPlayer openALMemoryAudioPlayer = this;
        synchronized (openALMemoryAudioPlayer) {
            if (this.source == null) {
                return;
            }
            AL10.alSourceStop((int)this.source.getId());
            this.source = null;
        }
    }

    protected void check() {
        int n = AL10.alGetError();
        if (n != 0) {
            logger.info("OpenAL error was raised. errorCode=" + n);
        }
    }

    public void loop(boolean bl) {
        super.loop(bl);
        if (this.source != null) {
            AL10.alSourcei((int)this.source.getId(), (int)4103, (int)(bl ? 1 : 0));
        }
    }

    public void updateTrackPlacement() {
        Vector3f vector3f = this.getTrack().getWorldPosition();
        Vector3f vector3f2 = this.getTrack().getCurrVelocity();
        AL10.alSource3f((int)this.source.getId(), (int)4100, (float)vector3f.x, (float)vector3f.y, (float)vector3f.z);
        AL10.alSource3f((int)this.source.getId(), (int)4102, (float)vector3f2.x, (float)vector3f2.y, (float)vector3f2.z);
    }

    public void setVolume(float f) {
        super.setVolume(f);
        OpenALPropertyTool.applyChannelVolume(this.source, f);
    }

    public void setPitch(float f) {
        if (f > 0.0f && f <= 2.0f) {
            super.setPitch(f);
            OpenALPropertyTool.applyChannelPitch(this.source, this.getPitch());
        } else {
            logger.warning("Pitch must be > 0 and <= 2.0f");
        }
    }

    public void setMaxAudibleDistance(float f) {
        super.setMaxAudibleDistance(f);
        OpenALPropertyTool.applyChannelMaxAudibleDistance(this.source, f);
    }

    public void setMaxVolume(float f) {
        super.setMaxVolume(f);
        OpenALPropertyTool.applyChannelMaxVolume(this.source, f);
    }

    public void setMinVolume(float f) {
        super.setMinVolume(f);
        OpenALPropertyTool.applyChannelMinVolume(this.source, f);
    }

    public void setReferenceDistance(float f) {
        super.setReferenceDistance(f);
        OpenALPropertyTool.applyChannelReferenceDistance(this.source, f);
    }

    public void setRolloff(float f) {
        super.setRolloff(f);
        OpenALPropertyTool.applyChannelRolloff(this.source, f);
    }

    public int getBitRate() {
        return this.getBuffer().getBitRate();
    }

    public int getChannels() {
        return this.getBuffer().getChannels();
    }

    public int getDepth() {
        return this.getBuffer().getDepth();
    }

    public float getLength() {
        return this.getBuffer().getLength();
    }
}

