/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.audio.player;

import com.jmex.audio.AudioTrack;

public abstract class AudioPlayer {
    private AudioTrack track;
    private float minVolume;
    private float maxVolume = 1.0f;
    private float maxDistance;
    private float refDistance = 1.0f;
    private float rolloff;
    private float volume;
    private float pitch = 1.0f;
    private long startTime;
    private long pauseTime;
    private boolean loop;

    public AudioPlayer(AudioTrack audioTrack) {
        this.track = audioTrack;
    }

    public abstract void init();

    public abstract void play();

    public abstract void pause();

    public abstract void stop();

    public abstract void cleanup();

    public abstract boolean isPlaying();

    public abstract boolean isActive();

    public abstract boolean isStopped();

    public abstract void updateTrackPlacement();

    public abstract int getChannels();

    public abstract int getBitRate();

    public abstract int getDepth();

    public abstract float getLength();

    public abstract void applyTrackProperties();

    public void loop(boolean bl) {
        this.loop = bl;
    }

    public boolean isLoop() {
        return this.loop;
    }

    public AudioTrack getTrack() {
        return this.track;
    }

    public void setMinVolume(float f) {
        this.minVolume = f;
    }

    public void setMaxVolume(float f) {
        this.maxVolume = f;
    }

    public void setMaxAudibleDistance(float f) {
        this.maxDistance = f;
    }

    public void setReferenceDistance(float f) {
        this.refDistance = f;
    }

    public void setRolloff(float f) {
        this.rolloff = f;
    }

    public void setVolume(float f) {
        this.volume = f;
    }

    public void setPitch(float f) {
        this.pitch = f;
    }

    public float getMaxDistance() {
        return this.maxDistance;
    }

    public void setMaxDistance(float f) {
        this.maxDistance = f;
    }

    public float getRefDistance() {
        return this.refDistance;
    }

    public void setRefDistance(float f) {
        this.refDistance = f;
    }

    public float getMaxVolume() {
        return this.maxVolume;
    }

    public float getMinVolume() {
        return this.minVolume;
    }

    public float getRolloff() {
        return this.rolloff;
    }

    public float getVolume() {
        return this.volume;
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getCurrentTime() {
        return (float)(System.currentTimeMillis() - this.startTime) / 1000.0f;
    }

    public void setStartTime(long l) {
        this.startTime = l;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setPauseTime(long l) {
        this.pauseTime = l;
    }

    public long getPauseTime() {
        return this.pauseTime;
    }
}

