/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.largeobject;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import org.postgresql.largeobject.LargeObject;

public class BlobOutputStream
extends OutputStream {
    private LargeObject lo;
    private byte[] buf;
    private int bsize;
    private int bpos;

    public BlobOutputStream(LargeObject lo) {
        this(lo, 1024);
    }

    public BlobOutputStream(LargeObject lo, int bsize) {
        this.lo = lo;
        this.bsize = bsize;
        this.buf = new byte[bsize];
        this.bpos = 0;
    }

    public void close() throws IOException {
        try {
            this.flush();
            this.lo.close();
            this.lo = null;
        }
        catch (SQLException se) {
            throw new IOException(se.toString());
        }
    }

    public void flush() throws IOException {
        try {
            if (this.bpos > 0) {
                this.lo.write(this.buf, 0, this.bpos);
            }
            this.bpos = 0;
        }
        catch (SQLException se) {
            throw new IOException(se.toString());
        }
    }

    public void write(int b) throws IOException {
        try {
            if (this.bpos >= this.bsize) {
                this.lo.write(this.buf);
                this.bpos = 0;
            }
            this.buf[this.bpos++] = (byte)b;
        }
        catch (SQLException se) {
            throw new IOException(se.toString());
        }
    }

    public void write(byte[] buf, int off, int len) throws IOException {
        try {
            if (this.bpos > 0) {
                this.flush();
            }
            if (off == 0 && len == buf.length) {
                this.lo.write(buf);
            } else {
                this.lo.write(buf, off, len);
            }
        }
        catch (SQLException se) {
            throw new IOException(se.toString());
        }
    }
}

