/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.debug;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.alinous.AlinousCore;
import org.alinous.debug.AlinousDebugEventNotifier;
import org.alinous.debug.DebugThread;
import org.alinous.debug.FileBreakpointContainer;
import org.alinous.script.IScriptBlock;
import org.alinous.script.runtime.VariableRepository;

public class AbstractAlinousDebugManager {
    protected Map<Long, DebugThread> threads = new HashMap<Long, DebugThread>();
    protected Map<String, FileBreakpointContainer> breakPointContainers = new HashMap<String, FileBreakpointContainer>();
    protected AlinousDebugEventNotifier debugEventNotifier = new AlinousDebugEventNotifier();
    protected AlinousCore alinousCore;
    protected long hotThread;

    public AbstractAlinousDebugManager(AlinousCore alinousCore) {
        this.alinousCore = alinousCore;
        this.hotThread = -1L;
    }

    public DebugThread[] getThreads() {
        ArrayList<DebugThread> list = new ArrayList<DebugThread>();
        for (Long thid : this.threads.keySet()) {
            DebugThread th = this.threads.get(thid);
            list.add(th);
        }
        return list.toArray(new DebugThread[list.size()]);
    }

    protected DebugThread getThread(long threadId) {
        return this.threads.get(new Long(threadId));
    }

    protected DebugThread getThread() {
        Thread th = Thread.currentThread();
        Long thId = new Long(th.getId());
        return this.threads.get(thId);
    }

    protected void createStackFrame(IScriptBlock scriptBlock, VariableRepository repo) {
        DebugThread currentThread = this.getThread();
        currentThread.newStackFrame(scriptBlock, repo);
    }

    public void destoryStackFrame() {
        DebugThread currentThread = this.getThread();
        currentThread.destroyStackFrame();
    }

    public void setDebugPort(int port) {
        this.debugEventNotifier.setPort(port);
    }

    public long getHotThread() {
        return this.hotThread;
    }

    public void setHotThread(long hotThread) {
        this.hotThread = hotThread;
    }
}

