/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.debug;

import org.alinous.AlinousCore;
import org.alinous.debug.AlinousServerDebugHttpResponse;
import org.alinous.debug.DebugEventSupport;
import org.alinous.debug.DebugThread;
import org.alinous.debug.FileBreakpointContainer;
import org.alinous.debug.ServerBreakpoint;
import org.alinous.debug.breakstatus.DefaultOperation;
import org.alinous.debug.breakstatus.IDebuggerOperation;
import org.alinous.debug.command.client.IClientRequest;
import org.alinous.debug.command.server.NotifyThreadEndedCommand;
import org.alinous.debug.command.server.NotifyThreadStartCommand;
import org.alinous.expections.AlinousException;

public class AlinousDebugManager
extends DebugEventSupport {
    public AlinousDebugManager(AlinousCore alinousCore) {
        super(alinousCore);
    }

    public void startAlinousOperation() {
        Thread th = Thread.currentThread();
        DebugThread newThread = new DebugThread(th, this, this);
        Long thId = new Long(th.getId());
        this.threads.put(thId, newThread);
        try {
            this.debugEventNotifier.notifyToClient(new NotifyThreadStartCommand());
        }
        catch (AlinousException e) {
            this.alinousCore.reportError(e);
        }
    }

    public void endAlinousOperation() {
        Thread th = Thread.currentThread();
        Long thId = new Long(th.getId());
        this.threads.remove(thId);
        try {
            this.debugEventNotifier.notifyToClient(new NotifyThreadEndedCommand());
        }
        catch (AlinousException e) {
            this.alinousCore.reportError(e);
        }
    }

    public void clearBreakpoints() {
        this.breakPointContainers.clear();
    }

    public FileBreakpointContainer getFileBreakpointContainer(String filePath) {
        FileBreakpointContainer container = (FileBreakpointContainer)this.breakPointContainers.get(filePath);
        if (container == null) {
            container = new FileBreakpointContainer();
            this.breakPointContainers.put(filePath, container);
        }
        return container;
    }

    public void addBreakPoint(ServerBreakpoint breakpoint) {
        this.getFileBreakpointContainer(breakpoint.getFilePath()).addBreakpoint(breakpoint);
    }

    public void setBreakpoints(ServerBreakpoint[] breakpoints) {
        this.breakPointContainers.clear();
        for (int i = 0; i < breakpoints.length; ++i) {
            String filePath = breakpoints[i].getFilePath();
            FileBreakpointContainer container = (FileBreakpointContainer)this.breakPointContainers.get(filePath);
            if (container == null) {
                container = new FileBreakpointContainer();
                this.breakPointContainers.put(filePath, container);
            }
            container.addBreakpoint(breakpoints[i]);
        }
    }

    public AlinousServerDebugHttpResponse handleClientRequest(IClientRequest request) {
        return request.executeRequest(this);
    }

    public void resume(long threadId) {
        DebugThread thread = this.getThread(threadId);
        thread.resume();
    }

    public void setOperation(long threadId, IDebuggerOperation ope) {
        DebugThread thread = this.getThread(threadId);
        thread.setOperation(ope, this);
    }

    public void initOperation() {
        long threadId = Thread.currentThread().getId();
        this.setOperation(threadId, new DefaultOperation());
    }

    public DebugThread getCurrentThread() {
        long threadId = Thread.currentThread().getId();
        return (DebugThread)this.threads.get(new Long(threadId));
    }
}

