/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.debug;

import org.alinous.AlinousCore;
import org.alinous.debug.AbstractAlinousDebugManager;
import org.alinous.debug.AlinousDebugEvent;
import org.alinous.debug.IThreadEventListner;
import org.alinous.debug.command.server.IServerCommand;
import org.alinous.debug.command.server.NotifyHitBreakpoint;
import org.alinous.debug.command.server.NotifyResumeComand;
import org.alinous.debug.command.server.NotifyStepInFinishedCommand;
import org.alinous.debug.command.server.NotifyStepOverFinishedCommand;
import org.alinous.debug.command.server.NotifyStepReturnFinishedCommand;
import org.alinous.expections.AlinousException;
import org.alinous.script.IScriptBlock;
import org.alinous.script.IScriptSentence;
import org.alinous.script.runtime.VariableRepository;

public abstract class DebugEventSupport
extends AbstractAlinousDebugManager
implements IThreadEventListner {
    public DebugEventSupport(AlinousCore alinousCore) {
        super(alinousCore);
    }

    protected void fireEvent(AlinousDebugEvent event) {
        switch (event.getEventType()) {
            case 1: {
                this.handleBeforeSentence(event);
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
    }

    public void sendCommand2Client(IServerCommand command) {
        try {
            this.debugEventNotifier.notifyToClient(command);
        }
        catch (AlinousException e) {
            this.alinousCore.reportError(e);
        }
    }

    public void aboutToExecuteSentence(IScriptBlock block, IScriptSentence nextSentence) {
        AlinousDebugEvent event = new AlinousDebugEvent(1, nextSentence.getLine(), block.getFilePath(), this.getThread());
        event.setSentence(nextSentence);
        this.fireEvent(event);
    }

    public void afterExecutedFunctionArgumentStatement(IScriptSentence callerSentenc) {
        AlinousDebugEvent event = new AlinousDebugEvent(4, callerSentenc.getLine(), callerSentenc.getFilePath(), this.getThread());
        event.setSentence(callerSentenc);
        this.fireEvent(event);
    }

    public void handleBeforeSentence(AlinousDebugEvent event) {
        this.getThread().getOperation().handleEvent(event);
    }

    public void createStackFrame(IScriptBlock scriptBlock, VariableRepository repo) {
        super.createStackFrame(scriptBlock, repo);
        AlinousDebugEvent event = new AlinousDebugEvent(3, scriptBlock.getLine(), scriptBlock.getFilePath(), this.getThread());
        this.fireEvent(event);
    }

    public AlinousCore getAlinousCore() {
        return this.alinousCore;
    }

    public void fireThreadAboutToSuspend(int reason) {
        IServerCommand cmd = null;
        switch (reason) {
            case 1: {
                cmd = new NotifyHitBreakpoint();
                break;
            }
            case 2: {
                cmd = new NotifyStepInFinishedCommand();
                break;
            }
            case 3: {
                cmd = new NotifyStepOverFinishedCommand();
                break;
            }
            case 4: {
                cmd = new NotifyStepReturnFinishedCommand();
                break;
            }
        }
        try {
            if (cmd != null) {
                this.debugEventNotifier.notifyToClient(cmd);
            }
        }
        catch (AlinousException e) {
            this.getAlinousCore().reportError(e);
        }
    }

    public void fireThreadResumed() {
        try {
            this.debugEventNotifier.notifyToClient(new NotifyResumeComand());
        }
        catch (AlinousException e) {
            this.getAlinousCore().reportError(e);
        }
    }
}

