/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.debug;

import org.alinous.debug.StepInCandidates;
import org.alinous.script.IScriptBlock;
import org.alinous.script.runtime.VariableRepository;
import org.jdom.Content;
import org.jdom.Element;

public class DebugStackFrame {
    public static final String TAG_STACKFRAME = "STACKFRAME";
    public static final String ATTR_LINE = "line";
    public static final String ATTR_FILENAME = "filename";
    public static final String ATTR_PEEK = "peek";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_STACKID = "stackId";
    public static final String ATTR_STEPIN_CANDIDATES = "stepin";
    public static final String ATTR_STEPIN_EXECUTED = "exeuted";
    private int line;
    private String fileName;
    private String name;
    private boolean peek;
    private VariableRepository repo;
    private long stackId;
    private StepInCandidates currentCandidate;
    private int executedCandidate;

    public DebugStackFrame(IScriptBlock block, VariableRepository repo) {
        if (block == null) {
            return;
        }
        this.line = block.getLine();
        this.fileName = block.getFilePath();
        this.name = block.getName();
        this.repo = repo;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public boolean isPeek() {
        return this.peek;
    }

    public void setPeek(boolean peek) {
        this.peek = peek;
    }

    public void exportIntoJDomElement(Element parent) {
        Element element = new Element(TAG_STACKFRAME);
        element.setAttribute(ATTR_LINE, Integer.toString(this.line));
        element.setAttribute(ATTR_FILENAME, this.fileName);
        element.setAttribute(ATTR_PEEK, Boolean.toString(this.peek));
        element.setAttribute(ATTR_NAME, this.name);
        element.setAttribute(ATTR_STACKID, Long.toString(this.stackId));
        if (this.currentCandidate != null) {
            element.setAttribute(ATTR_STEPIN_CANDIDATES, Integer.toString(this.currentCandidate.getCount()));
        } else {
            element.setAttribute(ATTR_STEPIN_CANDIDATES, Integer.toString(0));
        }
        element.setAttribute(ATTR_STEPIN_EXECUTED, Integer.toString(this.executedCandidate));
        this.repo.exportIntoJDomElement(element);
        parent.addContent((Content)element);
    }

    public void importFromJDomElement(Element stackFrameElement) {
        String strExecCount;
        String strLine = stackFrameElement.getAttributeValue(ATTR_LINE);
        if (strLine != null) {
            this.line = Integer.parseInt(strLine);
        }
        this.fileName = stackFrameElement.getAttributeValue(ATTR_FILENAME);
        String strPeek = stackFrameElement.getAttributeValue(ATTR_PEEK);
        if (strPeek != null) {
            this.peek = Boolean.parseBoolean(strPeek);
        }
        this.name = stackFrameElement.getAttributeValue(ATTR_NAME);
        String stackIdString = stackFrameElement.getAttributeValue(ATTR_STACKID);
        this.stackId = Long.parseLong(stackIdString);
        String strCandidates = stackFrameElement.getAttributeValue(ATTR_STEPIN_CANDIDATES);
        if (strCandidates != null) {
            this.currentCandidate = new StepInCandidates();
            this.currentCandidate.setCount(Integer.parseInt(strCandidates));
        }
        if ((strExecCount = stackFrameElement.getAttributeValue(ATTR_STEPIN_EXECUTED)) != null) {
            this.executedCandidate = Integer.parseInt(strExecCount);
        }
        Element valueRepoElement = stackFrameElement.getChild("VALUE_REPOSITORY");
        this.repo = new VariableRepository();
        this.repo.importFromJDomElement(valueRepoElement);
    }

    public String getName() {
        return this.name;
    }

    public VariableRepository getRepo() {
        return this.repo;
    }

    public long getStackId() {
        return this.stackId;
    }

    public void setStackId(long stackId) {
        this.stackId = stackId;
    }

    public StepInCandidates getCurrentCandidate() {
        return this.currentCandidate;
    }

    public void setCurrentCandidate(StepInCandidates currentCandidate) {
        this.currentCandidate = currentCandidate;
    }

    public int getExecutedCandidate() {
        return this.executedCandidate;
    }

    public void incCandidate() {
        ++this.executedCandidate;
    }

    public void resetExecutedCandidate() {
        this.executedCandidate = 0;
    }

    public boolean canStepIn() {
        return this.currentCandidate.getCount() > this.executedCandidate;
    }
}

