/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.debug.command.client;

import java.util.HashMap;
import java.util.Map;
import org.alinous.debug.AlinousDebugManager;
import org.alinous.debug.AlinousServerDebugHttpResponse;
import org.alinous.debug.ServerBreakpoint;
import org.alinous.debug.command.client.IClientRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddBreakpointsRequest
implements IClientRequest {
    public static final String LINE = "LINE";
    public static final String FILE_PATH = "FILE_PATH";
    private ServerBreakpoint breakpoint;

    public AddBreakpointsRequest() {
    }

    public AddBreakpointsRequest(ServerBreakpoint breakpoint) {
        this.breakpoint = breakpoint;
    }

    @Override
    public AlinousServerDebugHttpResponse executeRequest(AlinousDebugManager debugManager) {
        debugManager.addBreakPoint(this.breakpoint);
        AlinousServerDebugHttpResponse responce = new AlinousServerDebugHttpResponse(0);
        return responce;
    }

    @Override
    public String getCommand() {
        return "CMD_ADD_BREAKPOINTS";
    }

    @Override
    public Map<String, String> getParamMap() {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put(LINE, Integer.toString(this.breakpoint.getLine()));
        m.put(FILE_PATH, this.breakpoint.getFilePath());
        return m;
    }

    @Override
    public void importParams(Map<String, String> params) {
        String filePath = params.get(FILE_PATH);
        String strLine = params.get(LINE);
        int line = -1;
        if (strLine != null) {
            line = Integer.parseInt(strLine);
        }
        this.breakpoint = new ServerBreakpoint(filePath, line);
    }
}

