/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.debug.command.client;

import java.util.HashMap;
import java.util.Map;
import org.alinous.debug.AlinousDebugManager;
import org.alinous.debug.AlinousServerDebugHttpResponse;
import org.alinous.debug.breakstatus.StepOverOperation;
import org.alinous.debug.command.client.IClientRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StepOverRequest
implements IClientRequest {
    public static final String THREAD_ID = "THREAD_ID";
    public static final String STACK_ID = "STACK_ID";
    private long threadId;
    private long stackId;

    @Override
    public AlinousServerDebugHttpResponse executeRequest(AlinousDebugManager debugManager) {
        debugManager.setOperation(this.threadId, new StepOverOperation(this.stackId));
        debugManager.resume(this.threadId);
        AlinousServerDebugHttpResponse responce = new AlinousServerDebugHttpResponse(0);
        return responce;
    }

    @Override
    public String getCommand() {
        return "CMD_STEP_OVER";
    }

    @Override
    public Map<String, String> getParamMap() {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put(THREAD_ID, Long.toString(this.threadId));
        m.put(STACK_ID, Long.toString(this.stackId));
        return m;
    }

    @Override
    public void importParams(Map<String, String> params) {
        String strStackId;
        String strThreadId = params.get(THREAD_ID);
        if (strThreadId != null) {
            this.threadId = Long.parseLong(strThreadId);
        }
        if ((strStackId = params.get(STACK_ID)) != null) {
            this.stackId = Long.parseLong(strStackId);
        }
    }

    public long getThreadId() {
        return this.threadId;
    }

    public void setThreadId(long threadId) {
        this.threadId = threadId;
    }

    public long getStackId() {
        return this.stackId;
    }

    public void setStackId(long stackId) {
        this.stackId = stackId;
    }
}

