/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.exec;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.alinous.AlinousUtils;
import org.alinous.datasrc.DataSrcConnection;
import org.alinous.datasrc.exception.DataSourceException;
import org.alinous.datasrc.types.Record;
import org.alinous.exec.ExecResultRecord;
import org.alinous.exec.InnerModulePath;
import org.alinous.exec.VariableRepositoryStoreSupport;
import org.alinous.exec.pages.PostContext;
import org.alinous.expections.AlinousException;
import org.alinous.repository.AlinousSystemRepository;
import org.alinous.script.runtime.IPathElement;
import org.alinous.script.runtime.IScriptVariable;
import org.alinous.script.runtime.VariableRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecResultCache
extends VariableRepositoryStoreSupport {
    private AlinousSystemRepository systemRepository;
    private String sessionId;

    public ExecResultCache(AlinousSystemRepository sysRepo, String sessionId) {
        this.systemRepository = sysRepo;
        this.sessionId = sessionId;
    }

    public void storeResult(PostContext context, VariableRepository repo, InnerModulePath targetPath, String filePath) throws AlinousException {
        HashMap<IPathElement, ExecResultRecord> variableMap = new HashMap<IPathElement, ExecResultRecord>();
        Iterator<String> it = repo.getKeyIterator();
        while (it.hasNext()) {
            String key = it.next();
            IScriptVariable variable = repo.getValue(key);
            this.dump(variable, variableMap, context, repo);
        }
        try {
            this.storeIntoSystemRepository(variableMap, targetPath, filePath);
        }
        catch (DataSourceException e) {
            throw new AlinousException(e, "Failed to store records.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeIntoSystemRepository(Map<IPathElement, ExecResultRecord> variableMap, InnerModulePath targetPath, String filePath) throws AlinousException, DataSourceException {
        DataSrcConnection con = null;
        try {
            con = this.systemRepository.getConnection();
        }
        catch (DataSourceException e) {
            throw new AlinousException(e, "Failed in connect on ExecResult cache");
        }
        try {
            con.begin();
        }
        catch (DataSourceException e) {
            this.systemRepository.closeConnection(con);
            throw e;
        }
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("SESSION_ID", this.sessionId);
        queryParams.put("MODULE_PATH", AlinousUtils.sqlEscape(targetPath.getStringPath()));
        queryParams.put("FILE_PATH", AlinousUtils.sqlEscape(filePath));
        try {
            this.systemRepository.deleteRecord(con, "ALINOUS_VALUES", queryParams);
        }
        catch (AlinousException e) {
            this.systemRepository.closeConnection(con);
            throw e;
        }
        catch (DataSourceException e) {
            this.systemRepository.closeConnection(con);
            throw e;
        }
        ArrayList<Record> recordsList = new ArrayList<Record>();
        for (IPathElement pathElement : variableMap.keySet()) {
            ExecResultRecord val = variableMap.get(pathElement);
            Record rec = new Record();
            rec.addFieldValue("SESSION_ID", this.sessionId);
            rec.addFieldValue("MODULE_PATH", AlinousUtils.sqlEscape(targetPath.getStringPath()));
            rec.addFieldValue("FILE_PATH", AlinousUtils.sqlEscape(filePath));
            rec.addFieldValue("NAME_PATH", AlinousUtils.sqlEscape(val.getName()));
            rec.addFieldValue("TYPE", val.getType());
            rec.addFieldValue("VALUE_TYPE", val.getValueType());
            rec.addFieldValue("VALUE", AlinousUtils.sqlEscape(val.getValue()));
            rec.addFieldValue("CREATE_TIME", AlinousUtils.getNowString());
            recordsList.add(rec);
        }
        if (!recordsList.isEmpty()) {
            try {
                this.systemRepository.insertRecord(con, "ALINOUS_VALUES", recordsList);
            }
            catch (DataSourceException e) {
                this.systemRepository.closeConnection(con);
                throw new AlinousException(e, "Failed to insert record");
            }
        }
        try {
            con.commit();
        }
        finally {
            this.systemRepository.closeConnection(con);
        }
    }

    public VariableRepository getResultCache(InnerModulePath targetPath, String filePath) throws AlinousException {
        VariableRepository cache = new VariableRepository();
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("SESSION_ID", this.sessionId);
        queryParams.put("MODULE_PATH", targetPath.getStringPath());
        queryParams.put("FILE_PATH", filePath);
        List<Record> recordsList = null;
        try {
            recordsList = this.systemRepository.selectRecord("ALINOUS_VALUES", queryParams);
        }
        catch (DataSourceException e) {
            throw new AlinousException(e, "Failed to read ExecutionResultCache");
        }
        for (Record rec : recordsList) {
            String namePath = rec.getFieldValue("NAME_PATH");
            String type = rec.getFieldValue("TYPE");
            String valueType = rec.getFieldValue("VALUE_TYPE");
            String value = rec.getFieldValue("VALUE");
            if (!type.equals("HASH")) continue;
            cache.putValue(namePath, value, valueType, null);
        }
        return cache;
    }
}

