/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.jdk.converter;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.alinous.jdk.converter.BeanHandler;
import org.alinous.jdk.converter.BeanProperty;
import org.alinous.jdk.converter.PrimitiveHandler;
import org.alinous.script.runtime.IScriptVariable;
import org.alinous.script.runtime.ScriptArray;
import org.alinous.script.runtime.ScriptDomVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dom2Native {
    private IScriptVariable domVariable;
    private Class<?> nativeClass;

    public Dom2Native(IScriptVariable domVariable, Class<?> nativeClass) {
        this.domVariable = domVariable;
        this.nativeClass = nativeClass;
    }

    public Object convert() throws InstantiationException, IllegalAccessException, SecurityException, IllegalArgumentException, NoSuchMethodException, InvocationTargetException {
        if (this.domVariable == null) {
            return null;
        }
        return this.getObject(this.domVariable, this.nativeClass);
    }

    public Object convertArray() throws SecurityException, IllegalArgumentException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        if (this.domVariable == null) {
            return null;
        }
        if (!(this.domVariable instanceof ScriptArray)) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        ScriptArray ar = (ScriptArray)this.domVariable;
        Class<?> clazz = this.nativeClass;
        int max = ar.getSize();
        for (int i = 0; i < max; ++i) {
            Object object = this.getObject(ar.get(i), clazz.getComponentType());
            list.add(object);
        }
        Object retArray = Array.newInstance(clazz.getComponentType(), list.size());
        return list.toArray((Object[])retArray);
    }

    private Object getObject(IScriptVariable val, Class<?> clazz) throws InstantiationException, IllegalAccessException, SecurityException, IllegalArgumentException, NoSuchMethodException, InvocationTargetException {
        if (val == null) {
            return null;
        }
        if (PrimitiveHandler.isPrimitive(clazz)) {
            Object obj = PrimitiveHandler.newInstance(clazz, ((ScriptDomVariable)val).getValue());
            return obj;
        }
        if (val instanceof ScriptArray) {
            Object obj = this.newInstance(clazz);
            this.setupObjectAsCollection(obj, (ScriptArray)val);
            return obj;
        }
        if (val instanceof ScriptDomVariable) {
            Object obj = this.newInstance(clazz);
            this.setupObjectAsBean(obj, (ScriptDomVariable)val);
            return obj;
        }
        return this.newInstance(clazz);
    }

    private Object newInstance(Class<?> clazz) throws InstantiationException, IllegalAccessException {
        if (clazz.getName().equals("java.util.List")) {
            return null;
        }
        return clazz.newInstance();
    }

    private void setupObjectAsCollection(Object obj, ScriptArray scriptArray) throws InstantiationException, IllegalAccessException, SecurityException, IllegalArgumentException, NoSuchMethodException, InvocationTargetException {
        if (obj instanceof List) {
            List list = (List)obj;
            int max = scriptArray.getSize();
            for (int i = 0; i < max; ++i) {
                IScriptVariable val = scriptArray.get(i);
                Class<?> clazz = this.getListTemplateType(obj);
                Object newObj = this.getObject(val, clazz);
                list.add(newObj);
            }
        }
    }

    private Class<?> getListTemplateType(Object obj) {
        Class<?> clazz = obj.getClass();
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            if (!m.getName().equals("add") || m.getParameterTypes().length != 1) continue;
            return m.getParameterTypes()[0];
        }
        return null;
    }

    private void setupObjectAsBean(Object obj, ScriptDomVariable dom) throws InstantiationException, IllegalAccessException, SecurityException, NoSuchMethodException, IllegalArgumentException, InvocationTargetException {
        BeanHandler beanHandler = new BeanHandler(obj);
        ArrayList<BeanProperty> setterProps = beanHandler.getSetterProperties();
        for (BeanProperty p : setterProps) {
            IScriptVariable val = dom.get(p.getName());
            if (p.getClazz().isArray()) {
                this.setupArray(obj, p.getClazz(), val, p);
                continue;
            }
            Object newObject = this.getObject(val, p.getClazz());
            if (newObject == null) continue;
            Method m = obj.getClass().getMethod(p.getSetterName(), p.getClazz());
            m.invoke(obj, newObject);
        }
    }

    private void setupArray(Object beanObj, Class<?> arrayClass, IScriptVariable arrayVal, BeanProperty p) throws SecurityException, IllegalArgumentException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        if (!(arrayVal instanceof ScriptArray)) {
            return;
        }
        ScriptArray ar = (ScriptArray)arrayVal;
        ArrayList<Object> retList = new ArrayList<Object>();
        for (int i = 0; i < ar.getSize(); ++i) {
            IScriptVariable val = ar.get(i);
            Class<?> cmpClazz = arrayClass.getComponentType();
            Object newObj = this.getObject(val, cmpClazz);
            retList.add(newObj);
        }
        if (retList.size() == 0) {
            return;
        }
        Object beanArray = Array.newInstance(arrayClass.getComponentType(), retList.size());
        for (int i = 0; i < ((Object[])beanArray).length; ++i) {
            ((Object[])beanArray)[i] = retList.get(i);
        }
        Method m = beanObj.getClass().getMethod(p.getSetterName(), p.getClazz());
        m.invoke(beanObj, beanArray);
    }
}

