/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.objects;

import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.alinous.AlinousCore;
import org.alinous.AlinousUtils;
import org.alinous.datasrc.DataSrcConnection;
import org.alinous.datasrc.exception.DataSourceException;
import org.alinous.exec.AccessExecutionUnit;
import org.alinous.exec.ExecResultCache;
import org.alinous.exec.FormValueCache;
import org.alinous.exec.InnerModulePath;
import org.alinous.exec.pages.IDesign;
import org.alinous.exec.pages.IParamValue;
import org.alinous.exec.pages.IPostable;
import org.alinous.exec.pages.PostContext;
import org.alinous.expections.AlinousException;
import org.alinous.expections.ExecutionException;
import org.alinous.objects.AlinousAttrs;
import org.alinous.objects.Attribute;
import org.alinous.objects.IAlinousObject;
import org.alinous.objects.IAttributeValue;
import org.alinous.objects.InnserStatusContext;
import org.alinous.objects.html.AlinousTopObject;
import org.alinous.objects.html.FormTagObject;
import org.alinous.objects.validate.AlinousAttributeValidator;
import org.alinous.objects.validate.ValidationError;
import org.alinous.parser.ParsedElement;
import org.alinous.parser.script.attr.AlinousAttrScriptParser;
import org.alinous.parser.script.attr.ParseException;
import org.alinous.script.attribute.ParsedAttribute;
import org.alinous.script.runtime.IPathElement;
import org.alinous.script.runtime.IScriptVariable;
import org.alinous.script.runtime.PathElementFactory;
import org.alinous.script.runtime.ScriptArray;
import org.alinous.script.runtime.VariableRepository;
import org.alinous.security.AlinousSecurityManager;
import org.alinous.security.AuthenticationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XMLTagBase
implements ParsedElement,
IPostable,
IAlinousObject,
IDesign {
    public static final String TAG_ID = "alns:tagid";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_VALUE = "value";
    public static final String FORM_HIDDEN_VALIDATOR = "alns:validator:";
    protected Hashtable<String, Attribute> attributes = new Hashtable();
    protected Hashtable<String, Attribute> alinousAttributes = new Hashtable();
    protected List<XMLTagBase> innserObj = new CopyOnWriteArrayList<XMLTagBase>();
    protected VariableRepository valRepo;
    protected PostContext context;
    private int line;
    private int position;
    private XMLTagBase parent;

    @Override
    public void post(PostContext context, ExecResultCache resCache, FormValueCache formValues, VariableRepository valRepo) {
        this.valRepo = valRepo;
        this.context = context;
        this.postInner(context, resCache, formValues, valRepo);
    }

    protected void postInner(PostContext context, ExecResultCache resCache, FormValueCache formValues, VariableRepository valRepo) {
        for (IPostable iPostable : this.innserObj) {
            iPostable.post(context, resCache, formValues, valRepo);
        }
    }

    protected void renderInnerContents(PostContext context, Writer wr, int n) throws IOException, AlinousException {
        for (IDesign iDesign : this.innserObj) {
            iDesign.renderContents(context, wr, n + 1);
        }
    }

    protected void renderAttributes(Writer wr, int n) throws IOException {
        this.renderAttributes(wr, n, true, false);
    }

    protected void renderAttributes(Writer wr, int n, boolean renderValue, boolean adjustUri) throws IOException {
        Enumeration<String> enm = this.attributes.keys();
        while (enm.hasMoreElements()) {
            String key = enm.nextElement();
            Attribute atr = this.getAttribute(key);
            if (atr.getKey().toLowerCase().equals(ATTR_VALUE) && !renderValue || atr.getKey().toLowerCase().equals("checked") && !renderValue || atr.getKey().toLowerCase().equals("selected") && !renderValue || atr.getKey().toLowerCase().equals("href") && !renderValue) continue;
            boolean doAdjustUri = false;
            if (adjustUri && AlinousUtils.isUriReleavant(atr.getKey())) {
                doAdjustUri = true;
            }
            wr.write(" ");
            atr.renderContents(wr, n + 1, this.context, this.valRepo, doAdjustUri);
        }
    }

    protected void forkInnerObjects(XMLTagBase parentObj) throws AlinousException {
        for (IAlinousObject iAlinousObject : this.innserObj) {
            IAlinousObject forked = iAlinousObject.fork();
            parentObj.innserObj.add((XMLTagBase)forked);
            forked.setParent(parentObj);
        }
    }

    protected void copyAttribute(XMLTagBase src, XMLTagBase dest) {
        Enumeration<String> enm = src.attributes.keys();
        while (enm.hasMoreElements()) {
            String key = enm.nextElement();
            Attribute atr = null;
            try {
                atr = (Attribute)this.getAttribute(key).clone();
                if (AlinousAttrs.isAlinousAttr(atr)) {
                    dest.alinousAttributes.put(atr.getKey(), atr);
                    continue;
                }
                dest.attributes.put(atr.getKey(), atr);
            }
            catch (CloneNotSupportedException e) {}
        }
    }

    protected boolean handleInnserTag(PostContext context, Writer wr, int n) throws AlinousException, IOException {
        boolean bl;
        AlinousTopObject topObj = this.getTopObject();
        AlinousCore core = topObj.getAlinousCore();
        AccessExecutionUnit unit = core.createAccessExecutionUnit(context.getSessionId());
        try {
            bl = this.doHandleInnserTag(context, wr, n, unit);
        }
        catch (AlinousException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ExecutionException(e, "Fatal Error");
        }
        finally {
            unit.dispose();
        }
        return bl;
    }

    protected boolean doHandleInnserTag(PostContext context, Writer wr, int n, AccessExecutionUnit unit) throws AlinousException, IOException {
        Attribute inner = this.alinousAttributes.get("alns:inner");
        if (inner == null) {
            return false;
        }
        AlinousTopObject topObj = this.getTopObject();
        AlinousCore core = topObj.getAlinousCore();
        InnerModulePath modPath = this.getTopObject().getModulePath().deepClone();
        modPath.addPath(this.getTopObject().getPath());
        modPath.addTarget(this.getTagId());
        if (this.handleAuthenticationFault(topObj, context, inner, modPath, wr)) {
            return true;
        }
        InnserStatusContext innerStatus = this.getInnserObjectPath(topObj, context, inner, modPath);
        if (innerStatus.isSecurityErrorDefaultPage()) {
            AlinousSecurityManager.writeErrorInner(wr);
            return true;
        }
        core.registerAlinousObject(innerStatus.getNextModuleName());
        PostContext newContext = new PostContext(core, unit);
        newContext.setInner(true);
        newContext.initParams(context);
        newContext.setUseValuavleRepositoryCache(innerStatus.isUseVariableCache());
        newContext.setUseFormCache(innerStatus.isUseFormValueCache());
        IDesign design = null;
        design = unit.gotoPage(innerStatus.getNextModuleName(), newContext, modPath, this.getTopObject().getTopTopObject());
        if (design != null) {
            design.renderContents(newContext, wr, n);
            unit.getInnserStatusCache().storeLastPath(modPath, innerStatus.getNextModuleName());
        }
        return true;
    }

    private boolean handleAuthenticationFault(AlinousTopObject topObj, PostContext context, Attribute inner, InnerModulePath modPath, Writer wr) throws IOException {
        AuthenticationContext authContext = context.getAuthContext();
        if (authContext == null) {
            return false;
        }
        if (authContext.getZone().getErrorPage() != null && !authContext.getZone().getErrorPage().equals("")) {
            return false;
        }
        String targetPath = context.getTargetTagId();
        if (!targetPath.equals(modPath.getStringPath())) {
            return false;
        }
        AlinousSecurityManager.writeErrorInner(wr);
        return true;
    }

    private InnserStatusContext getInnserObjectPath(AlinousTopObject topObj, PostContext context, Attribute inner, InnerModulePath modPath) throws AlinousException {
        Attribute tagIdAttr = this.alinousAttributes.get(TAG_ID);
        if (tagIdAttr == null) {
            throw new ExecutionException("alns:tagid attribute does not exists at line " + this.getLine());
        }
        InnserStatusContext retContext = new InnserStatusContext();
        String targetPath = context.getTargetTagId();
        if (targetPath == null) {
            this.clearModpath(context, modPath);
            String htmlPath = inner.getValue().getValue();
            String modName = AlinousUtils.getModuleName(htmlPath);
            retContext.setNextModuleName(modName);
            retContext.setUseVariableCache(false);
            return retContext;
        }
        if (targetPath.equals(modPath.getStringPath())) {
            String nextAction = context.getNextAction();
            if (nextAction == null) {
                retContext.setSecurityErrorDefaultPage(true);
                return retContext;
            }
            retContext.setNextModuleName(AlinousUtils.getModuleName(nextAction));
            if (context.isBacking()) {
                retContext.setUseVariableCache(true);
                retContext.setUseFormValueCache(true);
            } else if (!context.getValidationStatus().getStatus()) {
                retContext.setUseVariableCache(true);
                retContext.setUseFormValueCache(true);
                String lastAction = context.getFormLastAction();
                retContext.setNextModuleName(AlinousUtils.getModuleName(lastAction));
            }
            return retContext;
        }
        String path = context.getUnit().getInnserStatusCache().getLastPath(modPath);
        if (path == null) {
            retContext.setNextModuleName(AlinousUtils.getModuleName(inner.getValue().getValue()));
            retContext.setUseVariableCache(false);
            retContext.setUseFormValueCache(false);
        } else {
            retContext.setNextModuleName(path);
            retContext.setUseVariableCache(true);
            retContext.setUseFormValueCache(true);
        }
        return retContext;
    }

    private void clearModpath(PostContext context, InnerModulePath modPath) throws ExecutionException {
        DataSrcConnection con = null;
        try {
            con = context.getCore().getSystemRepository().getConnection();
        }
        catch (DataSourceException e) {
            throw new ExecutionException(e, "Failed in connect on handling InnserStatusCache");
        }
        try {
            context.getUnit().getInnserStatusCache().clear(con, modPath);
        }
        catch (DataSourceException e) {
            throw new ExecutionException(e, "Failed in connect on handling InnserStatusCache");
        }
        finally {
            context.getCore().getSystemRepository().closeConnection(con);
        }
    }

    public boolean handleIterateAttribute(PostContext context, Writer wr, int n) throws IOException, AlinousException {
        Attribute iterateAttr = this.alinousAttributes.get("alns:iterate");
        Attribute variableAttr = this.alinousAttributes.get("alns:variable");
        if (iterateAttr == null || variableAttr == null) {
            return false;
        }
        String strValuePath = iterateAttr.getValue().getValue();
        if (!strValuePath.startsWith("@")) {
            return false;
        }
        IPathElement variablePath = PathElementFactory.buildPathElement(strValuePath.substring(1));
        if (variablePath == null) {
            return false;
        }
        IScriptVariable scVal = this.valRepo.getVariable(variablePath, context);
        if (!(scVal instanceof ScriptArray)) {
            return false;
        }
        ScriptArray itArray = (ScriptArray)scVal;
        Iterator<IScriptVariable> it = itArray.iterator();
        while (it.hasNext()) {
            IScriptVariable val = it.next();
            try {
                IScriptVariable clonedVal = (IScriptVariable)val.clone();
                clonedVal.setName(variableAttr.getValue().getValue());
                this.valRepo.putValue(clonedVal);
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
                return false;
            }
            this.doRenderContent(context, wr, n);
        }
        return true;
    }

    protected void doRenderContent(PostContext context, Writer wr, int n) throws IOException, AlinousException {
    }

    public AlinousTopObject getTopObject() {
        XMLTagBase tag = this.parent;
        while (!(tag instanceof AlinousTopObject)) {
            tag = tag.getParent();
        }
        return (AlinousTopObject)tag;
    }

    public String getTagId() throws ExecutionException {
        Attribute tagId = this.alinousAttributes.get(TAG_ID);
        if (tagId == null) {
            throw new ExecutionException("alns:tagid is necessary in " + this.getTopObject().getPath() + " at " + this.line);
        }
        return tagId.getValue().getValue();
    }

    protected void renderHiddens(PostContext context, Writer wr, int n, List<FormHiddenValue> hiddens) throws IOException {
        for (FormHiddenValue val : hiddens) {
            val.renderHidden(wr, n);
        }
    }

    protected IParamValue getFormValue(PostContext context, String formName, String key) {
        IParamValue val = null;
        if (context.isUseFormCache()) {
            val = context.getFormValues().getMap(formName).get(key);
            return val;
        }
        val = context.getParams(key);
        return val;
    }

    public void putAttribute(String key, IAttributeValue value) {
        Attribute attribute = new Attribute();
        attribute.setKey(key.toLowerCase());
        attribute.setValue(value);
        this.attributes.put(key, attribute);
    }

    public Attribute getAttribute(String key) {
        return this.attributes.get(key);
    }

    public void addInnerObject(XMLTagBase tagObj) {
        this.innserObj.add(tagObj);
        tagObj.setParent(this);
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getLinePosition() {
        return this.position;
    }

    @Override
    public void setLine(int line) {
        this.line = line;
    }

    @Override
    public void setLinePosition(int pos) {
        this.position = pos;
    }

    public XMLTagBase getParent() {
        return this.parent;
    }

    @Override
    public void setParent(XMLTagBase parent) {
        this.parent = parent;
    }

    public FormTagObject getFormTagObject() {
        for (XMLTagBase tag = this; tag != null; tag = tag.getParent()) {
            if (tag instanceof AlinousTopObject) {
                return null;
            }
            if (!(tag instanceof FormTagObject)) continue;
            return (FormTagObject)tag;
        }
        return null;
    }

    protected boolean handleIf(PostContext context) throws ExecutionException {
        Attribute ifAttr = this.alinousAttributes.get("alns:if");
        if (ifAttr == null) {
            return true;
        }
        String ifStr = ifAttr.getValue().getValue();
        StringReader reader = new StringReader("<" + ifStr + ">");
        boolean bl = true;
        AlinousAttrScriptParser parser = new AlinousAttrScriptParser(reader);
        try {
            ParsedAttribute attr = parser.parse();
            bl = attr.evaluate(context, this.valRepo);
        }
        catch (ParseException e) {
            e.printStackTrace();
            reader.close();
            return true;
        }
        reader.close();
        return bl;
    }

    protected void handleValidationInfo(PostContext context, List<FormHiddenValue> hiddens) {
        Attribute attr = this.alinousAttributes.get("alns:validate");
        if (attr == null) {
            return;
        }
        String strValidators = attr.getValue().getValue();
        if (strValidators == null) {
            return;
        }
        String[] validators = strValidators.split(",");
        for (int i = 0; i < validators.length; ++i) {
            String validatorName = validators[i];
            StringBuffer buff = new StringBuffer();
            buff.append(FORM_HIDDEN_VALIDATOR);
            buff.append(this.getFormTagObject().getFormId());
            buff.append(";");
            buff.append(this.getFullName());
            FormHiddenValue hidden = new FormHiddenValue(buff.toString(), validatorName);
            hiddens.add(hidden);
        }
    }

    public String getFullName() {
        Attribute nm = this.attributes.get(ATTR_NAME);
        if (nm != null) {
            return nm.getValue().getValue();
        }
        return "";
    }

    public void validateHtmlObject(List<ValidationError> errors) {
        if (this.isNameNeeded()) {
            this.checkAttributeExists(errors, ATTR_NAME);
        }
        if (this.isValueNeeded()) {
            this.checkAttributeExists(errors, ATTR_VALUE);
        }
        AlinousAttributeValidator attrValidator = new AlinousAttributeValidator(this, this.attributes);
        attrValidator.validate(errors);
        for (XMLTagBase base : this.innserObj) {
            base.validateHtmlObject(errors);
        }
    }

    protected boolean isValueNeeded() {
        return false;
    }

    protected boolean isNameNeeded() {
        return false;
    }

    public String getTagName() {
        return "";
    }

    private void checkAttributeExists(List<ValidationError> errors, String attrName) {
        Attribute attr = this.attributes.get(attrName);
        if (attr == null) {
            ValidationError er = new ValidationError(this.line, "<" + this.getTagName() + ">" + " doesn't have " + attrName + " attribute");
            errors.add(er);
        }
    }

    public class FormHiddenValue {
        private String key;
        private String value;

        public FormHiddenValue(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void renderHidden(Writer wr, int n) throws IOException {
            wr.write("<INPUT type=\"HIDDEN\" name=\"" + this.key);
            wr.write("\" ");
            wr.write("value=\"" + this.value + "\"");
            wr.write(">\n");
        }
    }
}

