/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.objects.html;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import org.alinous.exec.pages.ArrayParamValue;
import org.alinous.exec.pages.FormValues;
import org.alinous.exec.pages.IParamValue;
import org.alinous.exec.pages.PostContext;
import org.alinous.exec.pages.StringParamValue;
import org.alinous.expections.AlinousException;
import org.alinous.objects.Attribute;
import org.alinous.objects.IAlinousObject;
import org.alinous.objects.XMLTagBase;
import org.alinous.objects.html.AlinousTopObject;
import org.alinous.objects.html.FormTagObject;
import org.alinous.objects.html.IHtmlObject;
import org.alinous.objects.html.SelectTagObject;

public class OptionTagObject
extends XMLTagBase
implements IHtmlObject {
    public static final String ATTR_NAME = "name";
    public static final String ATTR_VALUE = "value";
    public static final String ATTR_SELECTED = "selected";

    public IAlinousObject fork() throws AlinousException {
        OptionTagObject newObj = new OptionTagObject();
        this.copyAttribute(this, newObj);
        this.forkInnerObjects(newObj);
        return newObj;
    }

    public void renderContents(PostContext context, Writer wr, int n) throws IOException, AlinousException {
        if (!this.handleIf(context)) {
            return;
        }
        if (this.handleIterateAttribute(context, wr, n)) {
            return;
        }
        this.doRenderContent(context, wr, n);
    }

    protected void doRenderContent(PostContext context, Writer wr, int n) throws IOException, AlinousException {
        wr.append("<OPTION");
        this.renderAttributes(wr, 0, false, false);
        wr.write(" ");
        this.renderValue(context, wr);
        wr.append(">");
        this.renderInnerContents(context, wr, n + 1);
        wr.append("</OPTION>\n");
    }

    private void renderValue(PostContext context, Writer wr) throws IOException {
        Attribute attrValue = (Attribute)this.attributes.get(ATTR_VALUE);
        if (attrValue == null || attrValue.getValue() == null) {
            return;
        }
        attrValue.renderContents(wr, 0, this.context, this.valRepo, false);
        this.renderChecked(context, wr);
    }

    private void renderChecked(PostContext context, Writer wr) throws IOException {
        if (!context.isUseFormCache()) {
            Attribute attrChecked = (Attribute)this.attributes.get(ATTR_SELECTED);
            if (attrChecked != null) {
                attrChecked.renderContents(wr, 0, this.context, this.valRepo, false);
            }
            return;
        }
        Attribute attrValue = (Attribute)this.attributes.get(ATTR_VALUE);
        if (attrValue == null) {
            return;
        }
        FormTagObject formTag = this.findFormTag();
        if (formTag == null) {
            return;
        }
        IParamValue val = this.getCachedValue(context, formTag);
        String selfValue = attrValue.getValue().getParsedValue(context, this.valRepo);
        if (selfValue == null) {
            return;
        }
        if (!(val instanceof ArrayParamValue)) {
            this.handleSingle(val, selfValue, wr);
            return;
        }
        ArrayParamValue arrayParam = (ArrayParamValue)val;
        if (arrayParam.containsValue(selfValue)) {
            wr.write(ATTR_SELECTED);
        }
    }

    private void handleSingle(IParamValue val, String selfValue, Writer wr) throws IOException {
        if (val == null) {
            return;
        }
        String strValue = ((StringParamValue)val).getValue();
        if (strValue == null) {
            return;
        }
        if (strValue.equals(selfValue)) {
            wr.write(ATTR_SELECTED);
        }
    }

    private FormTagObject findFormTag() {
        XMLTagBase base = this.getParent();
        while (!(base instanceof AlinousTopObject)) {
            if (base instanceof FormTagObject) {
                return (FormTagObject)base;
            }
            base = base.getParent();
        }
        return null;
    }

    private IParamValue getCachedValue(PostContext context, FormTagObject formTag) {
        String formId = formTag.getFormId();
        FormValues formValues = context.getFormValues();
        HashMap<String, IParamValue> map = formValues.getMap(formId);
        IParamValue val = (IParamValue)map.get(this.getName());
        return val;
    }

    private String getName() {
        XMLTagBase prt = this.getParent();
        if (!(prt instanceof SelectTagObject)) {
            return "";
        }
        SelectTagObject selTag = (SelectTagObject)prt;
        Attribute attr = selTag.getAttribute(ATTR_NAME);
        if (attr == null) {
            return "";
        }
        String retStr = attr.getValue().getValue();
        if (retStr.endsWith("[]")) {
            retStr = retStr.substring(0, retStr.length() - 2);
        }
        return retStr;
    }

    public String getTagName() {
        return "OPTION";
    }

    protected boolean isValueNeeded() {
        return true;
    }
}

