/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.scan;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.alinous.AlinousCore;
import org.alinous.AlinousUtils;
import org.alinous.expections.AlinousException;
import org.alinous.scan.AlinousObjectFilter;
import org.alinous.scan.AlinousScriptScanner;
import org.alinous.scan.DirectoryFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlinousHomeScanner {
    private String path;
    private AlinousCore alinousCore;

    public AlinousHomeScanner(String folder, AlinousCore core) {
        this.path = folder;
        this.alinousCore = core;
    }

    public void scan() {
        File dir = new File(this.path);
        LinkedList<String> htmlList = new LinkedList<String>();
        LinkedList<String> alnsList = new LinkedList<String>();
        AlinousObjectFilter objectFilter = new AlinousObjectFilter();
        File[] htmls = dir.listFiles(objectFilter);
        for (int i = 0; i < htmls.length; ++i) {
            String tmp = AlinousUtils.getHomeBasedPath(this.path, htmls[i].getPath());
            htmlList.add(tmp);
        }
        AlinousScriptScanner scriptFilter = new AlinousScriptScanner();
        File[] alnss = dir.listFiles(scriptFilter);
        for (int i = 0; i < htmls.length; ++i) {
            String tmp = AlinousUtils.getHomeBasedPath(this.path, alnss[i].getPath());
            alnsList.add(tmp);
        }
        DirectoryFilter dirFilter = new DirectoryFilter();
        File[] childDir = dir.listFiles(dirFilter);
        for (int i = 0; i < childDir.length; ++i) {
            this.scan(childDir[i], htmlList, alnsList);
        }
        for (String html : htmlList) {
            String alns = this.findReleavantScript(html, alnsList);
            if (alns != null) {
                alnsList.remove(alns);
            }
            try {
                this.alinousCore.registerAlinousObject(html, alns);
            }
            catch (AlinousException ignore) {
                this.alinousCore.reportError(ignore);
            }
        }
        for (String alns : alnsList) {
            try {
                this.alinousCore.registerAlinousObject(null, alns);
            }
            catch (AlinousException ignore) {
                this.alinousCore.reportError(ignore);
            }
        }
    }

    private String findReleavantScript(String html, List<String> alnsList) {
        String modulePath = AlinousUtils.getModuleName(html);
        String targetAlns = modulePath + "." + AlinousCore.EXT_ALNS;
        if (alnsList.contains(targetAlns)) {
            return targetAlns;
        }
        return null;
    }

    private void scan(File dir, List<String> htmlList, List<String> alnsList) {
        AlinousObjectFilter objectFilter = new AlinousObjectFilter();
        File[] htmls = dir.listFiles(objectFilter);
        for (int i = 0; i < htmls.length; ++i) {
            String tmp = AlinousUtils.getHomeBasedPath(this.path, htmls[i].getPath());
            htmlList.add(tmp);
        }
        AlinousScriptScanner scriptFilter = new AlinousScriptScanner();
        File[] alnss = dir.listFiles(scriptFilter);
        for (int i = 0; i < htmls.length; ++i) {
            String tmp = AlinousUtils.getHomeBasedPath(this.path, alnss[i].getPath());
            alnsList.add(tmp);
        }
        DirectoryFilter dirFilter = new DirectoryFilter();
        File[] childDir = dir.listFiles(dirFilter);
        for (int i = 0; i < childDir.length; ++i) {
            this.scan(childDir[i], htmlList, alnsList);
        }
    }
}

