/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.script.sql;

import java.util.LinkedList;
import java.util.List;
import org.alinous.AlinousConfig;
import org.alinous.datasrc.AlinousDataSourceManager;
import org.alinous.datasrc.DataSrcConnection;
import org.alinous.datasrc.exception.DataSourceException;
import org.alinous.datasrc.types.Record;
import org.alinous.debug.StepInCandidates;
import org.alinous.exec.pages.PostContext;
import org.alinous.expections.ExecutionException;
import org.alinous.script.ISQLSentence;
import org.alinous.script.runtime.IScriptVariable;
import org.alinous.script.runtime.ScriptArray;
import org.alinous.script.runtime.ScriptDomVariable;
import org.alinous.script.runtime.VariableRepository;
import org.alinous.script.sql.FromClause;
import org.alinous.script.sql.GroupByClause;
import org.alinous.script.sql.IntoClause;
import org.alinous.script.sql.LimitOffsetClause;
import org.alinous.script.sql.OrderByClause;
import org.alinous.script.sql.SelectColumns;
import org.alinous.script.sql.WhereClause;
import org.alinous.script.sql.adjustopt.AdjustSet;
import org.alinous.script.sql.adjustopt.AdjustWhere;
import org.alinous.script.sql.lock.ForUpdateClause;
import org.jdom.Content;
import org.jdom.Element;

public class SelectSentence
implements ISQLSentence {
    private SelectColumns columns;
    private String distinct;
    private IntoClause into;
    private FromClause from;
    private WhereClause where;
    private GroupByClause groupBy;
    private OrderByClause orderby;
    private LimitOffsetClause limitOffset;
    private ForUpdateClause forUpdate;
    private AdjustWhere adjustWhere;
    private int line;
    private int linePosition;
    private String filePath;
    private AlinousConfig config;
    private String dataSrc;

    public String getDistinct() {
        return this.distinct;
    }

    public void setDistinct(String distinct) {
        this.distinct = distinct;
    }

    public SelectColumns getColumns() {
        return this.columns;
    }

    public void setColumns(SelectColumns columns) {
        this.columns = columns;
    }

    public IntoClause getInto() {
        return this.into;
    }

    public void setInto(IntoClause into) {
        this.into = into;
    }

    public FromClause getFrom() {
        return this.from;
    }

    public void setFrom(FromClause from) {
        this.from = from;
    }

    public WhereClause getWhere() {
        return this.where;
    }

    public void setWhere(WhereClause where) {
        this.where = where;
    }

    public GroupByClause getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(GroupByClause groupBy) {
        this.groupBy = groupBy;
    }

    public LimitOffsetClause getLimitOffset() {
        return this.limitOffset;
    }

    public void setLimitOffset(LimitOffsetClause limitOffset) {
        this.limitOffset = limitOffset;
    }

    public OrderByClause getOrderby() {
        return this.orderby;
    }

    public void setOrderby(OrderByClause orderby) {
        this.orderby = orderby;
    }

    public ForUpdateClause getForUpdate() {
        return this.forUpdate;
    }

    public void setForUpdate(ForUpdateClause forUpdate) {
        this.forUpdate = forUpdate;
    }

    public AdjustWhere getAdjustWhere() {
        return this.adjustWhere;
    }

    public void setAdjustWhere(AdjustWhere adjustWhere) {
        this.adjustWhere = adjustWhere;
    }

    public void setConfig(AlinousConfig config) {
        this.config = config;
    }

    public void setDataSourceManager(AlinousDataSourceManager dataSourceManager) {
    }

    public void setDefaultDataSource(String defaultSrc) {
        this.dataSrc = defaultSrc;
    }

    public boolean execute(PostContext context, VariableRepository valRepo) throws ExecutionException {
        if (this.dataSrc == null) {
            this.dataSrc = this.config.getSystemRepositoryConfig().getDefaultSrc();
        }
        this.myAccept(valRepo);
        DataSrcConnection con = null;
        try {
            con = context.getUnit().getConnectionManager().connect(this.dataSrc);
        }
        catch (DataSourceException e) {
            throw new ExecutionException(e, "");
        }
        List<Object> recList = new LinkedList();
        try {
            recList = con.select(this.columns, this.from, this.where, this.groupBy, this.orderby, this.limitOffset, this.forUpdate);
        }
        catch (DataSourceException e) {
            throw new ExecutionException(e, "executing Select failed.");
        }
        if (this.into == null) {
            throw new ExecutionException("INTO cluase does not exists.");
        }
        String valueName = this.into.getVariable().getName();
        ScriptArray array = new ScriptArray(valueName);
        for (Record record : recList) {
            ScriptDomVariable hash = new ScriptDomVariable("Record");
            for (String fldName : record.getMap().keySet()) {
                ScriptDomVariable scriptVal = new ScriptDomVariable(fldName);
                String value = record.getFieldValue(fldName);
                scriptVal.setValue(value);
                hash.put(scriptVal);
            }
            array.add(hash);
        }
        valRepo.putValue(array);
        return true;
    }

    private void myAccept(VariableRepository valRepo) {
        if (this.columns != null) {
            this.columns.acceptVariables(valRepo, this.adjustWhere, null);
        }
        if (this.into != null) {
            this.into.acceptVariables(valRepo, this.adjustWhere, null);
        }
        if (this.from != null) {
            this.from.acceptVariables(valRepo, this.adjustWhere, null);
        }
        if (this.where != null) {
            this.where.acceptVariables(valRepo, this.adjustWhere, null);
        }
        if (this.groupBy != null) {
            this.groupBy.acceptVariables(valRepo, this.adjustWhere, null);
        }
        if (this.orderby != null) {
            this.orderby.acceptVariables(valRepo, null, null);
        }
        if (this.limitOffset != null) {
            this.limitOffset.acceptVariables(valRepo, null, null);
        }
        if (this.forUpdate != null) {
            this.forUpdate.acceptVariables(valRepo, null, null);
        }
    }

    public String extract(VariableRepository valRepo) throws ExecutionException {
        this.myAccept(valRepo);
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        sql.append(this.columns.extract());
        sql.append(" ");
        sql.append(this.from.extract());
        if (this.where != null && this.where.isReady()) {
            sql.append(" ");
            sql.append(this.where.extract());
        }
        if (this.groupBy != null && this.groupBy.isReady()) {
            sql.append(" ");
            sql.append(this.groupBy.extract());
        }
        if (this.orderby != null && this.orderby.isReady()) {
            sql.append(" ");
            sql.append(this.orderby.extract());
        }
        if (this.limitOffset != null && this.limitOffset.isReady()) {
            sql.append(" ");
            sql.append(this.limitOffset.extract());
        }
        if (this.forUpdate != null && this.forUpdate.isReady()) {
            sql.append(" ");
            sql.append(this.forUpdate.extract());
        }
        return sql.toString();
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public int getLinePosition() {
        return this.linePosition;
    }

    public void setLinePosition(int linePosition) {
        this.linePosition = linePosition;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public void exportIntoJDomElement(Element parent) {
        Element selectElement = new Element("EXECUTABLE");
        selectElement.setAttribute("execClass", this.getClass().getName());
        parent.addContent((Content)selectElement);
    }

    public void importFromJDomElement(Element element) {
    }

    public StepInCandidates getStepInCandidates() {
        return null;
    }

    public IScriptVariable getReturnedVariable() {
        return null;
    }

    public void acceptVariables(VariableRepository providor, AdjustWhere adjustWhere, AdjustSet adjustSet) {
    }

    public String extract() throws ExecutionException {
        return null;
    }

    public boolean isReady() throws ExecutionException {
        return false;
    }
}

