/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.security;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alinous.AlinousConfig;
import org.alinous.datasrc.AlinousDataSourceManager;
import org.alinous.datasrc.DataSrcConnection;
import org.alinous.datasrc.exception.DataSourceException;
import org.alinous.datasrc.types.DataTable;
import org.alinous.datasrc.types.Record;
import org.alinous.expections.AlinousException;
import org.alinous.expections.ExecutionException;
import org.alinous.script.sql.FromClause;
import org.alinous.script.sql.SelectColumns;
import org.alinous.script.sql.WhereClause;
import org.alinous.script.sql.condition.AndExpression;
import org.alinous.script.sql.condition.TwoClauseExpression;
import org.alinous.script.sql.other.TableIdentifier;
import org.alinous.script.sql.other.TablesList;
import org.alinous.script.sql.statement.Identifier;
import org.alinous.script.sql.statement.SQLStringConst;
import org.alinous.security.SecurityConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityRelmManager {
    private AlinousDataSourceManager dataSourceManager;
    private AlinousConfig config;

    public SecurityRelmManager(AlinousDataSourceManager dataSourceManager, AlinousConfig config) {
        this.dataSourceManager = dataSourceManager;
        this.config = config;
    }

    public void initRelmTable() throws AlinousException {
        SecurityConfig secConfig = this.config.getSecurityConfig();
        String dataSrc = secConfig.getRelmDataSource();
        String dataTable = secConfig.getRelmTable().toUpperCase();
        String userColumn = secConfig.getRelmUsers();
        String passColumn = secConfig.getRelmPasswords();
        String rolesColumn = secConfig.getRelmRoles();
        if (dataSrc == null) {
            throw new AlinousException("<datastore> does not exist in <relm> tag.");
        }
        if (dataTable == null) {
            throw new AlinousException("<table> does not exist in <relm> tag.");
        }
        if (userColumn == null) {
            throw new AlinousException("<users> does not exist in <relm> tag.");
        }
        if (passColumn == null) {
            throw new AlinousException("<passwords> does not exist in <relm> tag.");
        }
        if (rolesColumn == null) {
            throw new AlinousException("<roles> does not exist in <relm> tag.");
        }
        DataSrcConnection con = null;
        try {
            con = this.dataSourceManager.connect(dataSrc);
        }
        catch (DataSourceException e) {
            throw new AlinousException(e, "failed to connect datasource " + dataSrc);
        }
        DataTable tableObj = null;
        try {
            tableObj = con.getDataTable(dataTable);
        }
        catch (DataSourceException e) {
            con.close();
            throw new AlinousException(e, "Failed to get Metadata");
        }
        if (tableObj != null) {
            con.close();
            return;
        }
        try {
            this.createTable(con, dataTable, userColumn, passColumn, rolesColumn);
        }
        catch (DataSourceException e) {
            throw new AlinousException(e, "Failed to create the authentication table");
        }
        finally {
            con.close();
        }
    }

    private void createTable(DataSrcConnection con, String dataTable, String userColumn, String passColumn, String rolesColumn) throws DataSourceException {
        DataTable tableObj = new DataTable(dataTable);
        tableObj.addField(userColumn, "String", true, 128);
        tableObj.addField(passColumn, "String", true, 128);
        tableObj.addField(rolesColumn, "String");
        con.createTable(tableObj);
    }

    public List<Record> findRecords(String user, String password) throws AlinousException, DataSourceException {
        SecurityConfig secConfig = this.config.getSecurityConfig();
        String dataTable = secConfig.getRelmTable().toLowerCase();
        String userColumn = secConfig.getRelmUsers();
        String passColumn = secConfig.getRelmPasswords();
        if (dataTable == null) {
            throw new AlinousException("<table> does not exist in <relm> tag.");
        }
        if (userColumn == null) {
            throw new AlinousException("<users> does not exist in <relm> tag.");
        }
        if (passColumn == null) {
            throw new AlinousException("<passwords> does not exist in <relm> tag.");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(userColumn, user);
        params.put(passColumn, password);
        return this.selectRecord(dataTable, params);
    }

    private List<Record> selectRecord(String tableName, Map<String, String> queryParams) throws DataSourceException, AlinousException {
        SecurityConfig secConfig = this.config.getSecurityConfig();
        String dataSrc = secConfig.getRelmDataSource();
        if (dataSrc == null) {
            throw new AlinousException("<datastore> does not exist in <relm> tag.");
        }
        List<Record> recordList = null;
        DataSrcConnection con = this.dataSourceManager.connect(dataSrc);
        FromClause from = new FromClause();
        TablesList tableList = new TablesList();
        TableIdentifier table = new TableIdentifier();
        table.setTableName(tableName);
        tableList.addTable(table);
        from.setTableList(tableList);
        SelectColumns columns = new SelectColumns();
        WhereClause where = this.createWhereClauseFromParamMap(queryParams);
        try {
            recordList = con.select(columns, from, where, null, null, null, null);
        }
        catch (DataSourceException e) {
            throw e;
        }
        catch (ExecutionException e) {
            throw e;
        }
        finally {
            con.close();
        }
        return recordList;
    }

    private WhereClause createWhereClauseFromParamMap(Map<String, String> queryParams) {
        WhereClause where = new WhereClause();
        AndExpression andExp = new AndExpression();
        for (String field : queryParams.keySet()) {
            String val = queryParams.get(field);
            Identifier id = new Identifier();
            id.setName(field);
            SQLStringConst sqVal = new SQLStringConst();
            sqVal.setStr(val);
            TwoClauseExpression eqExp = new TwoClauseExpression();
            eqExp.setOpe("=");
            eqExp.setLeft(id);
            eqExp.setRight(sqVal);
            andExp.addExpressions(eqExp);
        }
        where.setExpression(andExp);
        return where;
    }
}

