/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.security;

import java.util.ArrayList;
import java.util.List;
import org.alinous.security.Zone;

public class ZoneMatchContext {
    private List<String> segments = new ArrayList<String>();
    private Zone zone;

    public ZoneMatchContext(String path, Zone zone) {
        this.zone = zone;
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        String[] pathes = path.split("/");
        for (int i = 0; i < pathes.length; ++i) {
            String p = pathes[i];
            if (p.length() == 0) continue;
            this.segments.add(p);
        }
    }

    public boolean match(String path) {
        StringBuffer buffer = new StringBuffer();
        String[] pathes = path.split("/");
        for (int i = 0; i < pathes.length - 1; ++i) {
            if (pathes[i].equals("")) continue;
            buffer.append("/");
            buffer.append(pathes[i]);
        }
        buffer.append("/");
        ZoneMatchContext inputContext = new ZoneMatchContext(buffer.toString(), null);
        if (inputContext.getNumSegments() < this.getNumSegments()) {
            return false;
        }
        int max = this.getNumSegments();
        for (int i = 0; i < max; ++i) {
            if (inputContext.get(i).equals(this.get(i))) continue;
            return false;
        }
        return true;
    }

    public String get(int i) {
        return this.segments.get(i);
    }

    public int getNumSegments() {
        return this.segments.size();
    }

    public Zone getZone() {
        return this.zone;
    }
}

