/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool.composite;

import java.io.Serializable;
import java.util.ListIterator;
import org.apache.commons.pool.composite.AbstractLender;
import org.apache.commons.pool.composite.CompositeObjectPool;
import org.apache.commons.pool.composite.Lender;

abstract class DelegateLender
extends AbstractLender
implements Serializable {
    private static final long serialVersionUID = -4403177642421760774L;
    private final Lender delegate;

    protected DelegateLender(Lender delegate) throws IllegalArgumentException {
        if (delegate == null) {
            throw new IllegalArgumentException("delegate Lender must not be null.");
        }
        this.delegate = delegate;
    }

    public void setCompositeObjectPool(CompositeObjectPool objectPool) throws IllegalArgumentException, IllegalStateException {
        super.setCompositeObjectPool(objectPool);
        this.delegate.setCompositeObjectPool(this.getObjectPool());
    }

    public Object borrow() {
        return this.delegate.borrow();
    }

    public void repay(Object obj) {
        this.delegate.repay(obj);
    }

    public ListIterator listIterator() {
        return this.delegate.listIterator();
    }

    public int size() {
        return this.delegate.size();
    }

    public String toString() {
        return this.delegate.toString();
    }
}

