/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool.composite;

import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.pool.composite.DelegateLender;
import org.apache.commons.pool.composite.Lender;

final class SoftLender
extends DelegateLender
implements Serializable {
    private static final long serialVersionUID = 8589090657730065177L;

    SoftLender(Lender delegate) throws IllegalArgumentException {
        super(delegate);
    }

    public Object borrow() {
        return ((Lender.LenderReference)super.borrow()).get();
    }

    public void repay(Object obj) {
        super.repay(new SoftLenderReference(obj));
    }

    public ListIterator listIterator() {
        return new SoftListIterator(super.listIterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        List lock;
        List list = lock = this.getObjectPool().getPool();
        synchronized (list) {
            ListIterator iter = super.listIterator();
            while (iter.hasNext()) {
                Reference ref = (Reference)iter.next();
                if (ref.get() != null) continue;
                iter.remove();
            }
        }
        return super.size();
    }

    public String toString() {
        return "Soft{" + super.toString() + "}";
    }

    private static class SoftListIterator
    implements ListIterator {
        private final ListIterator iter;

        private SoftListIterator(ListIterator iter) {
            this.iter = iter;
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Object next() {
            Reference ref = (Reference)this.iter.next();
            return ref != null ? ref.get() : null;
        }

        public boolean hasPrevious() {
            return this.iter.hasPrevious();
        }

        public Object previous() {
            Reference ref = (Reference)this.iter.previous();
            return ref != null ? ref.get() : null;
        }

        public int nextIndex() {
            return this.iter.nextIndex();
        }

        public int previousIndex() {
            return this.iter.previousIndex();
        }

        public void remove() {
            this.iter.remove();
        }

        public void set(Object o) {
            this.iter.set(o);
        }

        public void add(Object o) {
            this.iter.add(o);
        }
    }

    private static class SoftLenderReference
    extends SoftReference
    implements Lender.LenderReference {
        SoftLenderReference(Object referent) {
            super(referent);
        }
    }
}

