/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool.composite;

import java.io.Serializable;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.pool.composite.ActiveLimitManager;
import org.apache.commons.pool.composite.Manager;

final class WaitLimitManager
extends ActiveLimitManager
implements Serializable {
    private static final long serialVersionUID = 2536750269978303711L;
    private long maxWaitMillis = 0L;
    static final /* synthetic */ boolean $assertionsDisabled;

    WaitLimitManager(Manager delegate) throws IllegalArgumentException {
        super(delegate);
    }

    public Object nextFromPool() throws NoSuchElementException, Exception, InterruptedException {
        long endTime;
        List poolLock = this.objectPool.getPool();
        if (!$assertionsDisabled && !Thread.holdsLock(poolLock)) {
            throw new AssertionError();
        }
        long l = endTime = this.maxWaitMillis > 0L ? System.currentTimeMillis() + this.maxWaitMillis : Long.MAX_VALUE;
        while (this.maxWaitMillis <= 0L || endTime > System.currentTimeMillis()) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException("Interruption while waiting for an available object.");
            }
            if (this.objectPool.getNumActive() < this.getMaxActive()) {
                return super.nextFromPool();
            }
            if (this.objectPool.isOpen()) {
                long waitTime = Math.max(1L, endTime - System.currentTimeMillis());
                poolLock.wait(this.maxWaitMillis > 0L ? waitTime : 0L);
                continue;
            }
            throw new IllegalStateException("Trying to aquire an object from a closed pool.");
        }
        if (this.objectPool.isOpen()) {
            throw new NoSuchElementException("Unable to aquire new object in allowed time of: " + this.maxWaitMillis);
        }
        throw new IllegalStateException("Trying to aquire an object from a closed pool.");
    }

    public long getMaxWaitMillis() {
        return this.maxWaitMillis;
    }

    public void setMaxWaitMillis(long maxWaitMillis) {
        this.maxWaitMillis = maxWaitMillis;
    }

    public String toString() {
        return "WaitLimitManager{maxActive=" + this.getMaxActive() + ", maxWaitMillis=" + this.maxWaitMillis + ", delegate=" + super.toString() + '}';
    }

    static {
        $assertionsDisabled = !WaitLimitManager.class.desiredAssertionStatus();
    }
}

