/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool.composite;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.ObjectPoolFactory;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.composite.CompositeObjectPool;
import org.apache.commons.pool.composite.CompositeObjectPoolFactory;
import org.apache.commons.pool.composite.KeyedPoolableObjectFactoryAdapter;

final class CompositeKeyedObjectPool
implements KeyedObjectPool,
Cloneable,
Serializable {
    private static final long serialVersionUID = -5886463772111164686L;
    private final Map objectPools = new HashMap();
    private final ObjectPoolFactory poolFactory;
    private final transient ThreadLocal keys;
    private volatile boolean open = true;

    CompositeKeyedObjectPool(ObjectPoolFactory poolFactory) throws IllegalArgumentException {
        if (poolFactory == null) {
            throw new IllegalArgumentException("object pool factory must not be null.");
        }
        this.poolFactory = poolFactory;
        if (poolFactory instanceof CompositeObjectPoolFactory) {
            PoolableObjectFactory pof = ((CompositeObjectPoolFactory)poolFactory).getFactory();
            if (pof instanceof KeyedPoolableObjectFactoryAdapter) {
                this.keys = new ThreadLocal();
                ((KeyedPoolableObjectFactoryAdapter)pof).setCompositeKeyedObjectPool(this);
            } else {
                this.keys = null;
            }
        } else {
            this.keys = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectPool getObjectPool(Object key) {
        ObjectPool pool;
        Map map = this.objectPools;
        synchronized (map) {
            pool = (ObjectPool)this.objectPools.get(key);
            if (pool == null) {
                pool = this.poolFactory.createPool();
                this.objectPools.put(key, pool);
                if (pool instanceof CompositeObjectPool) {
                    ((CompositeObjectPool)pool).setOwningCompositeKeyedObjectPool(this);
                }
            }
        }
        return pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object borrowObject(Object key) throws Exception {
        this.assertOpen();
        ObjectPool pool = this.getObjectPool(key);
        try {
            if (this.keys != null) {
                this.keys.set(key);
            }
            Object object = pool.borrowObject();
            return object;
        }
        finally {
            if (this.keys != null) {
                this.keys.set(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnObject(Object key, Object obj) {
        ObjectPool pool = this.getObjectPool(key);
        try {
            if (this.keys != null) {
                this.keys.set(key);
            }
            pool.returnObject(obj);
        }
        catch (Exception e) {
        }
        finally {
            if (this.keys != null) {
                this.keys.set(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateObject(Object key, Object obj) {
        ObjectPool pool = this.getObjectPool(key);
        try {
            if (this.keys != null) {
                this.keys.set(key);
            }
            pool.invalidateObject(obj);
        }
        catch (Exception e) {
        }
        finally {
            if (this.keys != null) {
                this.keys.set(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObject(Object key) throws Exception {
        this.assertOpen();
        ObjectPool pool = this.getObjectPool(key);
        try {
            if (this.keys != null) {
                this.keys.set(key);
            }
            pool.addObject();
        }
        finally {
            if (this.keys != null) {
                this.keys.set(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumIdle(Object key) {
        ObjectPool pool = this.getObjectPool(key);
        try {
            if (this.keys != null) {
                this.keys.set(key);
            }
            int n = pool.getNumIdle();
            return n;
        }
        finally {
            if (this.keys != null) {
                this.keys.set(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumActive(Object key) {
        ObjectPool pool = this.getObjectPool(key);
        try {
            if (this.keys != null) {
                this.keys.set(key);
            }
            int n = pool.getNumActive();
            return n;
        }
        finally {
            if (this.keys != null) {
                this.keys.set(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumIdle() {
        int numIdle = 0;
        Map map = this.objectPools;
        synchronized (map) {
            Iterator iter = this.objectPools.values().iterator();
            while (iter.hasNext()) {
                ObjectPool pool = (ObjectPool)iter.next();
                numIdle += pool.getNumIdle();
            }
        }
        return numIdle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumActive() {
        int numActive = 0;
        Map map = this.objectPools;
        synchronized (map) {
            Iterator iter = this.objectPools.values().iterator();
            while (iter.hasNext()) {
                ObjectPool pool = (ObjectPool)iter.next();
                numActive += pool.getNumActive();
            }
        }
        return numActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws Exception {
        Map map = this.objectPools;
        synchronized (map) {
            Iterator iter = this.objectPools.keySet().iterator();
            while (iter.hasNext()) {
                Object key = iter.next();
                this.clear(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(Object key) throws Exception {
        ObjectPool pool = this.getObjectPool(key);
        try {
            if (this.keys != null) {
                this.keys.set(key);
            }
            pool.clear();
            Map map = this.objectPools;
            synchronized (map) {
                if (pool.getNumActive() == 0) {
                    this.objectPools.remove(key);
                    pool.close();
                }
            }
        }
        finally {
            if (this.keys != null) {
                this.keys.set(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.open = false;
        Thread.yield();
        Map map = this.objectPools;
        synchronized (map) {
            Iterator iter = this.objectPools.keySet().iterator();
            while (iter.hasNext()) {
                Object key = iter.next();
                this.close(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(Object key) {
        ObjectPool pool = this.getObjectPool(key);
        try {
            if (this.keys != null) {
                this.keys.set(key);
            }
            pool.close();
            Map map = this.objectPools;
            synchronized (map) {
                if (pool.getNumActive() == 0) {
                    this.objectPools.remove(key);
                    pool.close();
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (this.keys != null) {
                this.keys.set(null);
            }
        }
    }

    public void setFactory(KeyedPoolableObjectFactory factory) throws IllegalStateException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Replacing the factory not supported. Create a new pool instance instead.");
    }

    private void assertOpen() throws IllegalStateException {
        if (!this.open) {
            throw new IllegalStateException("keyed pool has been closed.");
        }
    }

    ThreadLocal getKeys() {
        return this.keys;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(128);
        sb.append("CompositeKeyedObjectPool{");
        sb.append("poolFactory=").append(this.poolFactory);
        sb.append(", open=").append(this.open);
        try {
            int numActive = this.getNumActive();
            sb.append(", activeObjects=").append(numActive);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            int numIdle = this.getNumIdle();
            sb.append(", idleObjects=").append(numIdle);
        }
        catch (Exception exception) {
            // empty catch block
        }
        sb.append('}');
        return sb.toString();
    }

    private Object readResolve() throws ObjectStreamException {
        CompositeKeyedObjectPool pool = new CompositeKeyedObjectPool(this.poolFactory);
        if (!this.open) {
            try {
                pool.close();
            }
            catch (Exception e) {
                InvalidObjectException ioe = new InvalidObjectException("pool close failed on serialized closed pool.");
                ioe.initCause(e);
                throw ioe;
            }
        }
        return pool;
    }
}

