/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool.composite;

import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.pool.composite.ReferenceTracker;

final class DebugTracker
extends ReferenceTracker
implements Serializable {
    private static final long serialVersionUID = -5536120104213707789L;
    private static final Logger LOGGER = Logger.getLogger(DebugTracker.class.getName());
    private static final String LOG_MESSAGE = "Borrowed object was not returned to the pool.";

    DebugTracker() {
    }

    protected ReferenceTracker.IdentityReference wrapBorrowed(Object obj) {
        return new StackWeakReference(obj, this.rq);
    }

    protected void referenceToBeRemoved(ReferenceTracker.IdentityReference ref) {
        LOGGER.log(Level.WARNING, LOG_MESSAGE, ((StackWeakReference)ref).getStack());
    }

    public String toString() {
        return "DebugTracker{active=" + this.map.size() + ", lost=" + this.getLost() + "}";
    }

    private static final class StackWeakReference
    extends WeakReference
    implements ReferenceTracker.IdentityReference {
        private static final String THROWABLE_MESSAGE = "Stack trace at time of borrow for: ";
        private final int ident;
        private final Throwable stack;

        StackWeakReference(Object referent, ReferenceQueue q) {
            super(referent, q);
            this.ident = System.identityHashCode(referent);
            this.stack = new Throwable(THROWABLE_MESSAGE + referent);
        }

        public ReferenceTracker.IdentityKey getKey() {
            return new ReferenceTracker.IdentityKey(this.ident);
        }

        public Throwable getStack() {
            return this.stack;
        }
    }
}

