/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool.composite;

import java.io.Serializable;
import java.util.NoSuchElementException;
import org.apache.commons.pool.composite.AbstractManager;

final class FailManager
extends AbstractManager
implements Serializable {
    private static final long serialVersionUID = 2245468648709521897L;
    private final transient ThreadLocal cause = new ThreadLocal();
    static final /* synthetic */ boolean $assertionsDisabled;

    FailManager() {
    }

    public Object nextFromPool() throws Exception {
        if (!$assertionsDisabled && !Thread.holdsLock(this.objectPool.getPool())) {
            throw new AssertionError();
        }
        Object obj = null;
        while (this.objectPool.getLender().size() > 0 && obj == null) {
            obj = this.objectPool.getLender().borrow();
            if (obj == null) continue;
            obj = this.activateOrDestroy(obj);
            try {
                if (obj == null || this.objectPool.getFactory().validateObject(obj)) continue;
                this.deferDestroyObject(obj);
                obj = null;
            }
            catch (Exception e) {
                this.updateCause(e);
                this.deferDestroyObject(obj);
                obj = null;
            }
        }
        if (obj == null) {
            Throwable t = (Throwable)this.cause.get();
            NoSuchElementException nsee = new NoSuchElementException("Pool configued to fail when exhausted.");
            if (t != null) {
                nsee.initCause(t);
                this.cause.set(null);
            }
            throw nsee;
        }
        this.cause.set(null);
        return obj;
    }

    private Object activateOrDestroy(Object obj) {
        try {
            this.objectPool.getFactory().activateObject(obj);
        }
        catch (Exception e) {
            this.updateCause(e);
            this.deferDestroyObject(obj);
            return null;
        }
        return obj;
    }

    private void updateCause(Throwable t) {
        Throwable previousCause = (Throwable)this.cause.get();
        if (previousCause != null) {
            t.initCause(previousCause);
        }
        this.cause.set(t);
    }

    public String toString() {
        return "FailManager{}";
    }

    static {
        $assertionsDisabled = !FailManager.class.desiredAssertionStatus();
    }
}

