/*
 * Decompiled with CFR 0.152.
 */
package org.alinous;

import org.alinous.AlinousConfig;
import org.alinous.AlinousMaintainThreadManager;
import org.alinous.datasrc.AlinousDataSourceManager;
import org.alinous.debug.AlinousDebugManager;
import org.alinous.exec.AccessExecutionUnit;
import org.alinous.expections.AlinousException;
import org.alinous.jdk.JavaConnectorFunctionManager;
import org.alinous.logger.AlinousLogger;
import org.alinous.repository.AlinousModuleRepository;
import org.alinous.repository.AlinousSystemRepository;
import org.alinous.security.AlinousSecurityManager;

public class AlinousCore {
    public static boolean debug = false;
    public static boolean community = false;
    private AlinousModuleRepository repository;
    private String alinousHome;
    private AlinousConfig config;
    private AlinousSecurityManager securityManager;
    private AlinousLogger logger;
    private AlinousDataSourceManager dataSourceManager;
    private JavaConnectorFunctionManager javaConnector;
    private AlinousSystemRepository systemRepository;
    AlinousMaintainThreadManager maintainanceService;
    private AlinousDebugManager debugManager;
    private static AlinousCore instance = null;
    public static String EXT_HTML = "html";
    public static String EXT_ALNS = "alns";

    private AlinousCore() {
    }

    public static synchronized AlinousCore getInstance(String alinousHome) throws Throwable {
        if (instance == null && alinousHome != null) {
            instance = new AlinousCore();
            try {
                instance.initInstance(alinousHome);
            }
            catch (Throwable e) {
                instance = null;
                if (e.getMessage() != null && e.getMessage().equals(new String(new byte[]{76, 73, 67, 69, 78, 83, 69, 32, 69, 82, 82, 79, 82}))) {
                    throw new AlinousException(e.getMessage());
                }
                throw e;
            }
        } else if (instance == null && alinousHome == null) {
            throw new AlinousException("Could not exitialize because alinousHome equals null.");
        }
        return instance;
    }

    private void initInstance(String home) throws AlinousException {
        this.alinousHome = home;
        this.config = new AlinousConfig(this.alinousHome);
        this.config.parseConfig();
        this.logger = new AlinousLogger(this.config, this.alinousHome);
        this.repository = new AlinousModuleRepository(this);
        this.dataSourceManager = new AlinousDataSourceManager(this.config.getDataSourceConfig(), this.logger);
        this.javaConnector = new JavaConnectorFunctionManager(home, this);
        try {
            this.javaConnector.init();
            this.javaConnector.startScan();
        }
        catch (InstantiationException e) {
            throw new AlinousException(e, "Failed to init JavaConnector");
        }
        catch (IllegalAccessException e) {
            throw new AlinousException(e, "Failed to init JavaConnector");
        }
        catch (ClassNotFoundException e) {
            throw new AlinousException(e, "Failed to init JavaConnector");
        }
        this.dataSourceManager.init(this);
        this.systemRepository = new AlinousSystemRepository(this.dataSourceManager);
        this.systemRepository.install(this.config.getSystemRepositoryConfig());
        this.securityManager = new AlinousSecurityManager(this, this.dataSourceManager, this.systemRepository, this.config);
        this.securityManager.init();
        if (debug) {
            this.debugManager = new AlinousDebugManager(this);
        }
        this.maintainanceService = new AlinousMaintainThreadManager(this.systemRepository, this.logger);
        this.maintainanceService.start();
    }

    public void registerAlinousObject(String dsPath, String acPath) throws AlinousException {
        this.repository.registerAlinousModule(dsPath, acPath);
    }

    public void registerAlinousObject(String moduleName) throws AlinousException {
        String designPath = moduleName + "." + EXT_HTML;
        String scriptPath = moduleName + "." + EXT_ALNS;
        this.registerAlinousObject(designPath, scriptPath);
    }

    public AccessExecutionUnit createAccessExecutionUnit(String sessionId) {
        AccessExecutionUnit retObj = new AccessExecutionUnit(this.repository, sessionId, this.systemRepository, this.dataSourceManager);
        retObj.setConfig(this.config);
        retObj.setSecurityManager(this.securityManager);
        return retObj;
    }

    public void reportError(AlinousException ex) {
        this.logger.reportError(ex);
    }

    public AlinousConfig getConfig() {
        return this.config;
    }

    public String getHome() {
        return this.alinousHome;
    }

    public AlinousDataSourceManager getDataSourceManager() {
        return this.dataSourceManager;
    }

    public AlinousDebugManager getAlinousDebugManager() {
        return this.debugManager;
    }

    public AlinousSystemRepository getSystemRepository() {
        return this.systemRepository;
    }

    public AlinousSecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public JavaConnectorFunctionManager getJavaConnector() {
        return this.javaConnector;
    }

    public void dispose() {
        this.javaConnector.endScan();
        this.maintainanceService.stop();
    }

    public AlinousLogger getLogger() {
        return this.logger;
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }
}

