/*
 * Decompiled with CFR 0.152.
 */
package org.alinous;

import java.util.Iterator;
import org.alinous.script.runtime.IScriptVariable;
import org.alinous.script.runtime.ScriptArray;
import org.alinous.script.runtime.ScriptDomVariable;
import org.alinous.script.runtime.VariableRepository;

public class AlinousDebug {
    public static void println(String str) {
        System.out.println(str);
    }

    public static void print(String str) {
        System.out.print(str);
    }

    public static synchronized void debugOut(Object str) {
        if (str == null) {
            System.out.println("null");
            System.out.flush();
            return;
        }
        System.out.println(str.toString());
        System.out.flush();
    }

    public static void printClientEventAccepted(String clazz) {
        System.out.println(clazz + " accepted.");
    }

    public static void printBreakpointHit(String file, int line) {
        System.out.println("BREAKPOINT : " + file + " at line" + line);
    }

    public static void dumpValues(VariableRepository repo) {
        AlinousDebug.println("-------------------------- DUMP VARIABLES -------------------------------");
        Iterator<String> it = repo.getKeyIterator();
        while (it.hasNext()) {
            String key = it.next();
            IScriptVariable variable = repo.getValue(key);
            AlinousDebug.dump(variable, 0);
        }
        AlinousDebug.println("-------------------------------------------------------------------------");
    }

    private static void dump(IScriptVariable variable, int indent) {
        if (variable instanceof ScriptDomVariable) {
            AlinousDebug.dumpHashValue((ScriptDomVariable)variable, indent);
        } else {
            AlinousDebug.dumpArray((ScriptArray)variable, indent);
        }
    }

    private static void dumpHashValue(ScriptDomVariable variable, int indent) {
        String name = variable.getName();
        String value = variable.getValue();
        String type = variable.getType();
        AlinousDebug.indent(indent);
        if (value != null) {
            AlinousDebug.println(name + " = " + value + " [" + type + "]");
        } else {
            AlinousDebug.println(name + " [" + type + "]");
        }
        Iterator<String> it = variable.getPropertiesIterator();
        while (it.hasNext()) {
            String prop = it.next();
            IScriptVariable val = variable.get(prop);
            AlinousDebug.indent(indent);
            AlinousDebug.println("property->" + prop);
            AlinousDebug.dump(val, indent + 1);
        }
    }

    private static void dumpArray(ScriptArray array, int indent) {
        String name = array.getName();
        String type = array.getType();
        AlinousDebug.indent(indent);
        AlinousDebug.println("Array @" + name + " [" + type + "]");
        Iterator<IScriptVariable> it = array.iterator();
        while (it.hasNext()) {
            IScriptVariable val = it.next();
            AlinousDebug.dump(val, indent + 1);
        }
    }

    private static void indent(int indent) {
        for (int i = 0; i < indent; ++i) {
            AlinousDebug.print("\t");
        }
    }
}

