/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.datasrc;

import java.util.Hashtable;
import org.alinous.AlinousCore;
import org.alinous.datasrc.DataSourceConfig;
import org.alinous.datasrc.DataSourceConfigCollection;
import org.alinous.datasrc.DataSrcConnection;
import org.alinous.datasrc.IAlinousDataSource;
import org.alinous.datasrc.basic.ILogProvidor;
import org.alinous.datasrc.exception.DataSourceException;

public class AlinousDataSourceManager {
    private Hashtable<String, IAlinousDataSource> dataSources = new Hashtable();
    private ILogProvidor logger;
    private DataSourceConfigCollection config;

    public AlinousDataSourceManager(DataSourceConfigCollection config, ILogProvidor logger) {
        this.logger = logger;
        this.config = config;
    }

    public void init(AlinousCore core) {
        int cnt = this.config.getCount();
        for (int i = 0; i < cnt; ++i) {
            DataSourceConfig cfg = this.config.getDataSourceConfig(i);
            String clazz = cfg.getClazz();
            IAlinousDataSource ds = null;
            try {
                ds = (IAlinousDataSource)Class.forName(clazz).newInstance();
                ds.setLogger(this.logger);
            }
            catch (InstantiationException e) {
                this.logger.reportError(e);
                continue;
            }
            catch (IllegalAccessException e) {
                this.logger.reportError(e);
                continue;
            }
            catch (ClassNotFoundException e) {
                this.logger.reportError(e);
                continue;
            }
            try {
                ds.setUri(cfg.getUri());
                ds.setUser(cfg.getUser());
                ds.setPass(cfg.getPass());
                ds.init(core);
            }
            catch (DataSourceException e) {
                this.logger.reportError(e);
                continue;
            }
            String srcId = cfg.getId();
            this.dataSources.put(srcId, ds);
        }
    }

    public DataSrcConnection connect(String dataSourceId) throws DataSourceException {
        IAlinousDataSource src = this.dataSources.get(dataSourceId);
        if (src == null) {
            throw new DataSourceException("Datasource id : " + dataSourceId + " was not found.");
        }
        DataSrcConnection con = new DataSrcConnection(src, this.logger);
        con.connect();
        return con;
    }
}

