/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.debug.breakstatus;

import org.alinous.debug.AlinousDebugEvent;
import org.alinous.debug.DebugStackFrame;
import org.alinous.debug.breakstatus.AbstractDebuggerOperation;
import org.alinous.exec.IExecutable;
import org.alinous.expections.AlinousException;

public class StepInOperation
extends AbstractDebuggerOperation {
    public void handleEvent(AlinousDebugEvent event) {
        switch (event.getEventType()) {
            case 4: {
                try {
                    this.handleAfterFunctionCallArgument(event);
                }
                catch (InterruptedException e) {
                    AlinousException ex = new AlinousException(e, "Could not suspend thread");
                    this.debugManager.getAlinousCore().reportError(ex);
                }
                return;
            }
        }
        this.thread.setNextExec(event.getSentence());
        long hitBreakPointId = this.hitBreakpoint(event);
        if (hitBreakPointId > 0L) {
            try {
                IExecutable exec = event.getSentence();
                this.debugManager.setHotThread(hitBreakPointId);
                this.thread.suspend(1, exec.getLine());
            }
            catch (InterruptedException e) {
                AlinousException ex = new AlinousException(e, "Could not suspend thread");
                this.debugManager.getAlinousCore().reportError(ex);
            }
            return;
        }
        this.suspendNormally(event);
    }

    private void handleAfterFunctionCallArgument(AlinousDebugEvent event) throws InterruptedException {
        DebugStackFrame stack = event.getThread().getTopStackFrame();
        if (stack.canStepIn()) {
            IExecutable exec = event.getSentence();
            this.debugManager.setHotThread(event.getThread().getThreadId());
            this.thread.suspend(1, exec.getLine());
        }
    }

    private void suspendNormally(AlinousDebugEvent event) {
        IExecutable exec = event.getSentence();
        try {
            this.thread.suspend(1, exec.getLine());
            this.debugManager.setHotThread(event.getThread().getThreadId());
        }
        catch (InterruptedException e) {
            AlinousException ex = new AlinousException(e, "Could not suspend thread");
            this.debugManager.getAlinousCore().reportError(ex);
        }
    }
}

