/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.debug.breakstatus;

import org.alinous.debug.AlinousDebugEvent;
import org.alinous.debug.DebugStackFrame;
import org.alinous.debug.breakstatus.AbstractDebuggerOperation;
import org.alinous.exec.IExecutable;
import org.alinous.expections.AlinousException;

public class StepReturnOperation
extends AbstractDebuggerOperation {
    private long currentStackId;

    public StepReturnOperation(long currentStackId) {
        this.currentStackId = currentStackId;
    }

    public void handleEvent(AlinousDebugEvent event) {
        switch (event.getEventType()) {
            case 4: {
                return;
            }
        }
        this.thread.setNextExec(event.getSentence());
        long hitBreakPointId = this.hitBreakpoint(event);
        if (hitBreakPointId > 0L) {
            try {
                IExecutable exec = event.getSentence();
                this.debugManager.setHotThread(hitBreakPointId);
                this.thread.suspend(1, exec.getLine());
            }
            catch (InterruptedException e) {
                AlinousException ex = new AlinousException(e, "Could not suspend thread");
                this.debugManager.getAlinousCore().reportError(ex);
            }
            return;
        }
        boolean returned = this.returned(event);
        if (returned) {
            this.suspendByStepReturn(event);
        }
    }

    private void suspendByStepReturn(AlinousDebugEvent event) {
        try {
            IExecutable exec = event.getSentence();
            this.debugManager.setHotThread(event.getThread().getThreadId());
            this.thread.suspend(4, exec.getLine());
        }
        catch (InterruptedException e) {
            AlinousException ex = new AlinousException(e, "Could not suspend thread");
            this.debugManager.getAlinousCore().reportError(ex);
        }
    }

    private boolean returned(AlinousDebugEvent event) {
        DebugStackFrame[] frames = event.getThread().getStackFrames();
        for (int i = 0; i < frames.length; ++i) {
            DebugStackFrame f = frames[i];
            if (f.getStackId() != this.currentStackId) continue;
            return false;
        }
        return true;
    }
}

