/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.debug.command.client;

import java.util.Map;
import org.alinous.debug.command.client.AddBreakpointsRequest;
import org.alinous.debug.command.client.ClearBreakpointsRequest;
import org.alinous.debug.command.client.IClientRequest;
import org.alinous.debug.command.client.ResumeRequest;
import org.alinous.debug.command.client.SetupAllBreakPointsRequest;
import org.alinous.debug.command.client.StatusThreadRequest;
import org.alinous.debug.command.client.StepInRequest;
import org.alinous.debug.command.client.StepOverRequest;
import org.alinous.debug.command.client.StepReturnRequest;
import org.alinous.debug.command.client.TerminateServerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientRequestFactory {
    public static IClientRequest createRequest(Map<String, String> params) {
        String command = params.get("COMMAND");
        IClientRequest retRequest = null;
        if (command == null) {
            return null;
        }
        if (command.equals("CMD_TERMINATE")) {
            retRequest = new TerminateServerRequest();
        } else if (command.equals("CMD_STATUS_THREAD")) {
            retRequest = new StatusThreadRequest();
        } else if (command.equals("CMD_CLEAR_BREAKPOINTS")) {
            retRequest = new ClearBreakpointsRequest();
        } else if (command.equals("CMD_ADD_BREAKPOINTS")) {
            retRequest = new AddBreakpointsRequest();
        } else if (command.equals("CMD_SETUP_ALL_BREAKPOINTS")) {
            retRequest = new SetupAllBreakPointsRequest();
        } else if (command.equals("CMD_RESUME")) {
            retRequest = new ResumeRequest(0L);
        } else if (command.equals("CMD_STEP_OVER")) {
            retRequest = new StepOverRequest();
        } else if (command.equals("CMD_STEP_IN")) {
            retRequest = new StepInRequest();
        } else if (command.equals("CMD_STEP_RETURN")) {
            retRequest = new StepReturnRequest();
        }
        if (retRequest != null) {
            retRequest.importParams(params);
        }
        return retRequest;
    }

    public static IClientRequest createDefault() {
        return new StatusThreadRequest();
    }
}

