/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.debug.command.client;

import java.util.HashMap;
import java.util.Map;
import org.alinous.debug.AlinousDebugManager;
import org.alinous.debug.AlinousServerDebugHttpResponse;
import org.alinous.debug.DebugThread;
import org.alinous.debug.command.client.IClientRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatusThreadRequest
implements IClientRequest {
    public static final String THREAD_ID = "THREAD_ID";
    private long threadId = -1L;
    private boolean breakpoint = false;

    @Override
    public String getCommand() {
        return new String("CMD_STATUS_THREAD");
    }

    @Override
    public Map<String, String> getParamMap() {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put(THREAD_ID, Long.toString(this.threadId));
        return m;
    }

    @Override
    public void importParams(Map<String, String> params) {
        String strThreadId = params.get(THREAD_ID);
        this.threadId = strThreadId != null ? Long.parseLong(strThreadId) : -1L;
    }

    @Override
    public AlinousServerDebugHttpResponse executeRequest(AlinousDebugManager debugManager) {
        AlinousServerDebugHttpResponse responce = null;
        responce = this.threadId > 0L ? this.exportThread(debugManager) : this.exportAllThreads(debugManager);
        long hotThreadId = debugManager.getHotThread();
        responce.setHotThread(hotThreadId);
        if (this.breakpoint) {
            debugManager.setHotThread(-1L);
        }
        return responce;
    }

    private AlinousServerDebugHttpResponse exportAllThreads(AlinousDebugManager debugManager) {
        AlinousServerDebugHttpResponse responce = new AlinousServerDebugHttpResponse(0);
        DebugThread[] threads = debugManager.getThreads();
        for (int i = 0; i < threads.length; ++i) {
            responce.addThread(threads[i]);
        }
        return responce;
    }

    private AlinousServerDebugHttpResponse exportThread(AlinousDebugManager debugManager) {
        AlinousServerDebugHttpResponse responce = new AlinousServerDebugHttpResponse(0);
        DebugThread[] threads = debugManager.getThreads();
        for (int i = 0; i < threads.length; ++i) {
            responce.addThread(threads[i]);
        }
        return responce;
    }

    public void setBreakpoint(boolean breakpoint) {
        this.breakpoint = breakpoint;
    }
}

