/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.exec;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alinous.AlinousUtils;
import org.alinous.datasrc.DataSrcConnection;
import org.alinous.datasrc.exception.DataSourceException;
import org.alinous.datasrc.types.Record;
import org.alinous.exec.InnerModulePath;
import org.alinous.exec.pages.ArrayParamValue;
import org.alinous.exec.pages.FormValues;
import org.alinous.exec.pages.IParamValue;
import org.alinous.exec.pages.StringParamValue;
import org.alinous.expections.AlinousException;
import org.alinous.repository.AlinousSystemRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormValueCache {
    private AlinousSystemRepository systemRepository;
    private String sessionId;

    public FormValueCache(AlinousSystemRepository repo, String sessionId) {
        this.systemRepository = repo;
        this.sessionId = sessionId;
    }

    public void storeFormValue(InnerModulePath innerModPath, Map<String, IParamValue> params, String filePath, String formId) throws AlinousException {
        DataSrcConnection con = null;
        try {
            con = this.systemRepository.getConnection();
        }
        catch (DataSourceException e) {
            throw new AlinousException(e, "Failed in connect on FormValue cache");
        }
        try {
            con.begin();
        }
        catch (DataSourceException e) {
            this.systemRepository.closeConnection(con);
            throw new AlinousException(e, "Failed to begin TRX on FormValue");
        }
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("SESSION_ID", this.sessionId);
        queryParams.put("MODULE_PATH", AlinousUtils.sqlEscape(innerModPath.getStringPath()));
        queryParams.put("FILE_PATH", AlinousUtils.sqlEscape(filePath));
        try {
            this.systemRepository.deleteRecord(con, "ALINOUS_FORM_VALUES", queryParams);
        }
        catch (DataSourceException e) {
            this.systemRepository.closeConnection(con);
            throw new AlinousException(e, "Failed to delete FromValueCache");
        }
        ArrayList<Record> recordsList = new ArrayList<Record>();
        for (String key : params.keySet()) {
            IParamValue val = params.get(key);
            Record rec = new Record();
            if (formId != null) {
                rec.addFieldValue("FORM_ID", AlinousUtils.sqlEscape(formId));
            } else {
                rec.addFieldValue("FORM_ID", "");
            }
            rec.addFieldValue("SESSION_ID", this.sessionId);
            rec.addFieldValue("MODULE_PATH", AlinousUtils.sqlEscape(innerModPath.getStringPath()));
            rec.addFieldValue("FILE_PATH", AlinousUtils.sqlEscape(filePath));
            rec.addFieldValue("VARIABLE_NAME", AlinousUtils.sqlEscape(key));
            rec.addFieldValue("VALUE_TYPE", Integer.toString(val.getType()));
            rec.addFieldValue("VALUE", AlinousUtils.sqlEscape(((Object)val).toString()));
            rec.addFieldValue("CREATE_TIME", AlinousUtils.getNowString());
            recordsList.add(rec);
        }
        try {
            this.systemRepository.insertRecord(con, "ALINOUS_FORM_VALUES", recordsList);
        }
        catch (DataSourceException e) {
            this.systemRepository.closeConnection(con);
            throw new AlinousException(e, "Failed to insert FromValueCache");
        }
        try {
            con.commit();
        }
        catch (DataSourceException e) {
            throw new AlinousException(e, "Failed to delete FromValueCache");
        }
        finally {
            this.systemRepository.closeConnection(con);
        }
    }

    public FormValues loadFormValues(InnerModulePath innerModPath, String filePath) throws AlinousException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("SESSION_ID", this.sessionId);
        queryParams.put("MODULE_PATH", innerModPath.getStringPath());
        queryParams.put("FILE_PATH", filePath);
        List<Record> records = null;
        try {
            records = this.systemRepository.selectRecord("ALINOUS_FORM_VALUES", queryParams);
        }
        catch (DataSourceException e) {
            throw new AlinousException(e, "Failed to insert FromValueCache");
        }
        FormValues formValues = new FormValues();
        for (Record rec : records) {
            String key = rec.getFieldValue("VARIABLE_NAME");
            String val = rec.getFieldValue("VALUE");
            String formId = rec.getFieldValue("FORM_ID");
            String type = rec.getFieldValue("VALUE_TYPE");
            HashMap<String, IParamValue> map = formValues.getMap(formId);
            if (type.equals("1")) {
                map.put(key, new StringParamValue(val));
                continue;
            }
            ArrayParamValue arrayParam = new ArrayParamValue(val);
            map.put(key, arrayParam);
        }
        return formValues;
    }
}

