/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.exec;

import java.util.ArrayList;
import java.util.List;
import org.alinous.expections.AlinousException;

public class InnerModulePath {
    private List<PathElement> pathList = new ArrayList<PathElement>();

    public InnerModulePath(String filePath) throws AlinousException {
        if (filePath.equals("")) {
            return;
        }
        String[] strs = filePath.split(";");
        for (int i = 0; i < strs.length; ++i) {
            String str = strs[i];
            PathElement p = new PathElement(str);
            this.pathList.add(p);
        }
    }

    public InnerModulePath() {
    }

    public void addPath(String filePath) {
        PathElement p = new PathElement();
        p.setFilePath(filePath);
        this.pathList.add(p);
    }

    public void addTarget(String tagId) {
        PathElement p = this.pathList.get(this.pathList.size() - 1);
        p.setTagId(tagId);
    }

    public String getStringPath() {
        StringBuffer buffer = new StringBuffer();
        boolean first = true;
        for (PathElement p : this.pathList) {
            if (first) {
                first = false;
            } else {
                buffer.append(";");
            }
            buffer.append(p.toString());
        }
        return buffer.toString();
    }

    public InnerModulePath deepClone() throws AlinousException {
        InnerModulePath newObj = new InnerModulePath(this.getStringPath());
        return newObj;
    }

    class PathElement {
        private String filePath;
        private String tagId;

        public PathElement() {
        }

        public PathElement(String pathFormat) throws AlinousException {
            String[] strs = pathFormat.split(":");
            this.filePath = strs[0];
            if (strs.length == 2) {
                this.tagId = strs[1];
            }
        }

        public String getFilePath() {
            return this.filePath;
        }

        public void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        public String getTagId() {
            return this.tagId;
        }

        public void setTagId(String tagId) {
            this.tagId = tagId;
        }

        public String toString() {
            StringBuffer buff = new StringBuffer();
            buff.append(this.filePath);
            if (this.tagId != null) {
                buff.append(":");
                buff.append(this.tagId);
            }
            return buff.toString();
        }
    }
}

