/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.exec.pages;

import java.util.HashMap;
import java.util.Map;
import org.alinous.datasrc.AlinousDataSourceManager;
import org.alinous.datasrc.DataSrcConnection;
import org.alinous.datasrc.exception.DataSourceException;

public class ConnectionManager {
    private AlinousDataSourceManager dataSourceManager;
    private Map<String, DataSrcConnection> pool = new HashMap<String, DataSrcConnection>();

    public ConnectionManager(AlinousDataSourceManager dataSourceManager) {
        this.dataSourceManager = dataSourceManager;
    }

    public DataSrcConnection connect(String dataSrc) throws DataSourceException {
        DataSrcConnection conn = this.pool.get(dataSrc);
        if (conn == null) {
            conn = this.dataSourceManager.connect(dataSrc);
            this.pool.put(dataSrc, conn);
        }
        return conn;
    }

    public void dispose() {
        for (String key : this.pool.keySet()) {
            DataSrcConnection conn = this.pool.get(key);
            conn.close();
        }
    }
}

