/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.exec.validator;

import java.util.HashMap;
import org.alinous.exec.pages.IParamValue;
import org.alinous.exec.pages.PostContext;
import org.alinous.exec.validator.IValidator;
import org.alinous.exec.validator.ValidatorFactory;
import org.alinous.expections.AlinousException;
import org.alinous.expections.ExecutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationRequest {
    private String validatorName;
    private String inputName;
    private String formName;
    private String regExp;
    private boolean array;
    private IValidator validator;

    private ValidationRequest() {
    }

    public static ValidationRequest getRequest(String paramName, IParamValue validationType, HashMap<String, IParamValue> params) throws ExecutionException {
        if (!paramName.startsWith("alns:validator:")) {
            return null;
        }
        String inputString = paramName.substring("alns:validator:".length());
        String[] valInfo = inputString.split(";");
        if (valInfo.length != 2) {
            throw new ExecutionException("Validation Hidden's format is wrong.");
        }
        ValidationRequest req = new ValidationRequest();
        req.setValidatorName(((Object)validationType).toString());
        req.setInputName(valInfo[1]);
        req.setFormName(valInfo[0]);
        IParamValue alnsRegEx = params.get("alns:regexp");
        if (alnsRegEx != null) {
            req.setRegExp(((Object)alnsRegEx).toString());
        }
        return req;
    }

    public boolean validate(PostContext context) throws AlinousException {
        this.validator = ValidatorFactory.getValidator(this.validatorName);
        if (this.validator == null) {
            return true;
        }
        this.validator.setRegExp(this.regExp);
        this.validator.setFormName(this.formName);
        this.validator.setInputName(this.inputName);
        IParamValue formValue = context.getParams(this.inputName);
        boolean result = this.validator.validate(formValue, context, this.array);
        return result;
    }

    public boolean isCustom() {
        return this.validatorName.equals("custom");
    }

    public String getInputName() {
        return this.inputName;
    }

    public void setInputName(String inputName) {
        if (inputName.endsWith("[]")) {
            this.inputName = inputName.substring(0, inputName.length() - "[]".length());
            this.array = true;
            return;
        }
        this.inputName = inputName;
    }

    public String getValidatorName() {
        return this.validatorName;
    }

    public void setValidatorName(String validatorName) {
        this.validatorName = validatorName;
    }

    public String getRegExp() {
        return this.regExp;
    }

    public void setRegExp(String regExp) {
        this.regExp = regExp;
    }

    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    public IValidator getValidator() {
        return this.validator;
    }

    public void setValidator(IValidator validator) {
        this.validator = validator;
    }

    public boolean isArray() {
        return this.array;
    }
}

