/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.jdk;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.alinous.jdk.ClassEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarHandler {
    private String jarName;
    private String basePath;

    public JarHandler(String jarName, String basePath) {
        this.jarName = jarName;
        this.basePath = basePath;
    }

    public List<ClassEntry> initEntries() throws ZipException, IOException {
        ArrayList<ClassEntry> list = new ArrayList<ClassEntry>();
        File inFile = new File(this.getJarPath());
        ZipFile zipFile = new ZipFile(inFile);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            ClassEntry clazz = this.makeClassEntry(entry, zipFile);
            if (clazz == null) continue;
            list.add(clazz);
        }
        zipFile.close();
        return list;
    }

    private ClassEntry makeClassEntry(ZipEntry entry, ZipFile zipFile) throws IOException {
        if (!entry.getName().endsWith(".class") && !entry.getName().endsWith(".properties")) {
            return null;
        }
        InputStream inStream = zipFile.getInputStream(entry);
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
        byte[] buffer = new byte[256];
        int n = 1;
        while (n > 0) {
            n = inStream.read(buffer);
            if (n <= 0) continue;
            byteArray.write(buffer, 0, n);
        }
        byteArray.flush();
        ClassEntry clazz = new ClassEntry();
        clazz.setBytes(byteArray.toByteArray());
        if (entry.getName().endsWith(".properties")) {
            String name = entry.getName();
            clazz.setName(name);
            clazz.setResource(true);
        } else {
            String name = entry.getName().replaceAll("/", ".");
            clazz.setName(name.substring(0, name.length() - 6));
            clazz.setResource(false);
        }
        byteArray.close();
        return clazz;
    }

    private String getJarPath() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.basePath);
        if (!this.basePath.endsWith("/")) {
            buffer.append("/");
        }
        buffer.append(this.jarName);
        return buffer.toString();
    }
}

