/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.jdk.converter;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import org.alinous.jdk.converter.BeanProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanHandler {
    private Object obj;

    public BeanHandler(Object obj) {
        this.obj = obj;
    }

    public ArrayList<BeanProperty> getSetterProperties() {
        Method[] methods = this.obj.getClass().getMethods();
        ArrayList<BeanProperty> list = new ArrayList<BeanProperty>();
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            BeanProperty p = this.getSetterBeanProp(m);
            if (p == null) continue;
            list.add(p);
        }
        return list;
    }

    private BeanProperty getSetterBeanProp(Method m) {
        Type[] types = m.getGenericParameterTypes();
        if (types.length != 1) {
            return null;
        }
        if (!m.getName().startsWith("set")) {
            return null;
        }
        BeanProperty prop = new BeanProperty();
        if (types[0] instanceof ParameterizedType) {
            ParameterizedType t = (ParameterizedType)types[0];
            prop.setClazz((Class)t.getRawType());
        } else {
            prop.setClazz((Class)types[0]);
        }
        String propName = m.getName().substring(3, m.getName().length());
        char first = propName.charAt(0);
        first = Character.toLowerCase(first);
        propName = first + propName.substring(1);
        prop.setName(propName);
        return prop;
    }

    public Object invokeGetter(String getterName, Class<?> paramType) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> cls = this.obj.getClass();
        Method m = cls.getMethod(getterName, new Class[0]);
        Object ret = m.invoke(this.obj, new Object[0]);
        return ret;
    }
}

