/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.logger;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import org.alinous.AlinousUtils;

public class AlinousFileLogger {
    public static final String LIB_DIR = "/log/";
    private String alinousHome;

    public void reportError(String str) {
        String fileName = this.getFileName("error");
        try {
            this.writeLog(fileName, str);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void reportInfo(String str) {
        String fileName = this.getFileName("alinous");
        try {
            this.writeLog(fileName, str);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void init(String alinousHome) {
        this.alinousHome = alinousHome;
        String libDir = AlinousUtils.getAbsolutePath(this.alinousHome, LIB_DIR);
        File file = new File(libDir);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    private String getFileName(String prefix) {
        Long nowLong = System.currentTimeMillis();
        Timestamp now = new Timestamp(nowLong);
        SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMdd'.log'");
        String target = LIB_DIR + prefix + fmt.format(now);
        return AlinousUtils.getAbsolutePath(this.alinousHome, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void writeLog(String fileName, String message) throws IOException {
        File file = new File(fileName);
        FileOutputStream out = new FileOutputStream(file, true);
        try {
            out.write(message.getBytes());
        }
        finally {
            out.close();
        }
    }
}

