/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.objects.html;

import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import org.alinous.exec.pages.PostContext;
import org.alinous.expections.AlinousException;
import org.alinous.expections.ExecutionException;
import org.alinous.objects.Attribute;
import org.alinous.objects.HrefTargetParser;
import org.alinous.objects.IAlinousObject;
import org.alinous.objects.XMLTagBase;
import org.alinous.objects.html.AlinousTopObject;
import org.alinous.objects.html.IHtmlObject;
import org.alinous.parser.script.attr.AlinousAttrScriptParser;
import org.alinous.parser.script.attr.ParseException;
import org.alinous.script.attribute.ParsedAttribute;
import org.alinous.script.runtime.VariableRepository;

public class ATagObject
extends XMLTagBase
implements IHtmlObject {
    public IAlinousObject fork() throws AlinousException {
        ATagObject newObj = new ATagObject();
        this.copyAttribute(this, newObj);
        this.forkInnerObjects(newObj);
        return newObj;
    }

    public void renderContents(PostContext context, Writer wr, int n) throws IOException, AlinousException {
        if (!this.handleIf(context)) {
            return;
        }
        wr.append("<A");
        this.renderAttributes(wr, 0, false, true);
        this.renderHref(context, wr, n);
        wr.append(">");
        this.renderInnerContents(context, wr, n + 1);
        wr.append("</A>");
    }

    private void renderHref(PostContext context, Writer wr, int n) throws IOException, AlinousException {
        Attribute targetAttr = (Attribute)this.alinousAttributes.get("alns:target");
        Attribute hrefAttr = (Attribute)this.attributes.get("href");
        if (targetAttr == null) {
            if (hrefAttr != null) {
                wr.append(" ");
                hrefAttr.renderContents(wr, n, this.context, this.valRepo, true);
            }
            return;
        }
        String value = this.makeHrefString(hrefAttr.getValue().getValue(), targetAttr.getValue().getValue());
        wr.append(" ");
        wr.append("href=\"");
        wr.append(context.getFilePath(value));
        wr.append("\"");
    }

    private String makeHrefString(String href, String targetTag) throws AlinousException {
        href = this.getParsedValue(this.context, this.valRepo, href);
        HrefTargetParser targetParser = new HrefTargetParser(href);
        AlinousTopObject thisPage = this.getTopObject();
        AlinousTopObject toptopObj = thisPage.getTopTopObject();
        targetParser.setTopTopPage(toptopObj.getPath());
        targetParser.setThisPagePath(thisPage);
        targetParser.setTargetTagId(targetTag);
        return targetParser.getString();
    }

    private String getParsedValue(PostContext context, VariableRepository valRepo, String value) {
        StringReader reader = new StringReader("<" + value + ">");
        String str = null;
        AlinousAttrScriptParser parser = new AlinousAttrScriptParser(reader);
        try {
            ParsedAttribute attr = parser.parse();
            str = attr.expand(context, valRepo);
        }
        catch (ParseException e) {
            reader.close();
            return null;
        }
        catch (ExecutionException e) {
            reader.close();
            return null;
        }
        reader.close();
        return str;
    }

    public String getTagName() {
        return "A";
    }
}

