/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.plugin.derby;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.alinous.AlinousCore;
import org.alinous.AlinousDebug;
import org.alinous.datasrc.IAlinousDataSource;
import org.alinous.datasrc.basic.ILogProvidor;
import org.alinous.datasrc.exception.DataSourceException;
import org.alinous.datasrc.types.DataField;
import org.alinous.datasrc.types.DataTable;
import org.alinous.datasrc.types.Record;
import org.alinous.expections.ExecutionException;
import org.alinous.plugin.postgres.PostgreSQLConnectionFactory;
import org.alinous.script.sql.FromClause;
import org.alinous.script.sql.GroupByClause;
import org.alinous.script.sql.LimitOffsetClause;
import org.alinous.script.sql.OrderByClause;
import org.alinous.script.sql.SelectColumns;
import org.alinous.script.sql.SetClause;
import org.alinous.script.sql.WhereClause;
import org.alinous.script.sql.lock.ForUpdateClause;
import org.alinous.script.sql.other.ColumnList;
import org.alinous.script.sql.other.SelectColumnElement;
import org.alinous.script.sql.other.VariableList;
import org.alinous.script.sql.statement.ISQLStatement;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.StackObjectPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DerbyDataSource
implements IAlinousDataSource {
    private Driver driver;
    private String user;
    private String pass;
    private String uri;
    private PostgreSQLConnectionFactory factory;
    private StackObjectPool connectionPool;
    private boolean outSql = true;
    private ILogProvidor logger;
    private Map<Connection, Statement> batchedStatementMap = new HashMap<Connection, Statement>();

    @Override
    public void init(AlinousCore core) throws DataSourceException {
        try {
            this.driver = (Driver)Class.forName("org.apache.derby.jdbc.ClientDriver").newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new DataSourceException(e);
        }
        catch (InstantiationException e) {
            throw new DataSourceException(e);
        }
        catch (IllegalAccessException e) {
            throw new DataSourceException(e);
        }
        this.factory = new PostgreSQLConnectionFactory(this.driver, this.user, this.pass, this.uri);
        this.connectionPool = new StackObjectPool((PoolableObjectFactory)this.factory);
    }

    @Override
    public Object connect() throws DataSourceException {
        Connection con;
        try {
            con = (Connection)this.connectionPool.borrowObject();
        }
        catch (Exception e) {
            throw new DataSourceException(e);
        }
        return con;
    }

    @Override
    public void close(Object connectObj) {
        if (connectObj == null) {
            return;
        }
        Connection con = (Connection)connectObj;
        this.batchedStatementMap.remove(con);
        try {
            this.connectionPool.returnObject(connectObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean begin(Object connectionHandle) throws DataSourceException {
        boolean autoCommit;
        Connection con = (Connection)connectionHandle;
        try {
            autoCommit = con.getAutoCommit();
        }
        catch (SQLException e) {
            throw new DataSourceException(e);
        }
        try {
            con.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new DataSourceException(e);
        }
        Statement batchStmt = null;
        try {
            batchStmt = con.createStatement();
            this.batchedStatementMap.put(con, batchStmt);
        }
        catch (SQLException e) {
            throw new DataSourceException(e);
        }
        return autoCommit;
    }

    @Override
    public void commit(Object connectionHandle, boolean lastAutoCommit) throws DataSourceException {
        Connection con = (Connection)connectionHandle;
        Statement batchStmt = this.batchedStatementMap.get(con);
        if (batchStmt != null) {
            try {
                batchStmt.executeBatch();
            }
            catch (SQLException e) {
                try {
                    con.rollback();
                }
                catch (SQLException e1) {
                    // empty catch block
                }
                try {
                    con.setAutoCommit(lastAutoCommit);
                }
                catch (SQLException ignore) {
                    // empty catch block
                }
                try {
                    batchStmt.close();
                }
                catch (SQLException e1) {
                    // empty catch block
                }
                this.batchedStatementMap.remove(con);
                throw new DataSourceException(e);
            }
        }
        try {
            con.commit();
        }
        catch (SQLException e) {
            throw new DataSourceException(e);
        }
        finally {
            try {
                batchStmt.close();
            }
            catch (SQLException e1) {}
            try {
                con.setAutoCommit(lastAutoCommit);
            }
            catch (SQLException ignore) {}
            this.batchedStatementMap.remove(con);
        }
    }

    @Override
    public void rollback(Object connectionHandle, boolean lastAutoCommit) throws DataSourceException {
        Connection con = (Connection)connectionHandle;
        Statement batchStmt = this.batchedStatementMap.get(con);
        if (batchStmt != null) {
            try {
                batchStmt.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            this.batchedStatementMap.remove(con);
        }
        try {
            con.rollback();
        }
        catch (SQLException e) {
            throw new DataSourceException(e);
        }
        finally {
            try {
                con.setAutoCommit(lastAutoCommit);
            }
            catch (SQLException ignore) {}
        }
    }

    @Override
    public void createTable(Object connectionHandle, DataTable table) throws DataSourceException {
        LinkedList<DataField> fields = new LinkedList<DataField>();
        LinkedList<String> indexes = new LinkedList<String>();
        List<String> keys = table.getFields();
        for (String fld : keys) {
            DataField df = table.getDataField(fld);
            fields.add(df);
            if (!df.isPrimary()) continue;
            indexes.add(fld);
        }
        StringBuffer sqlString = new StringBuffer();
        sqlString.append("CREATE TABLE ");
        sqlString.append(table.getName());
        sqlString.append(" ( \n");
        boolean first = true;
        for (DataField fld : fields) {
            if (first) {
                first = false;
            } else {
                sqlString.append(",\n");
            }
            sqlString.append(fld.getName());
            sqlString.append(" ");
            sqlString.append(this.getSQLType(fld.getType()));
        }
        if (indexes.size() > 0) {
            sqlString.append(",\n");
            sqlString.append("PRIMARY KEY(");
            first = true;
            for (String idxFld : indexes) {
                if (first) {
                    first = false;
                } else {
                    sqlString.append(", ");
                }
                sqlString.append(idxFld);
            }
            sqlString.append(")");
        }
        sqlString.append("\n)\n");
        if (this.logger != null && this.outSql) {
            this.logger.reportInfo(sqlString.toString());
        }
        this.executeUpdateSQL(connectionHandle, sqlString.toString(), false);
    }

    private String getSQLType(String type) {
        if (type.equals("String")) {
            return "VARCHAR(256)";
        }
        if (type.equals("TEXT")) {
            return "VARCHAR(8192)";
        }
        if (type.equals("Integer")) {
            return "INTEGER";
        }
        if (type.equals("Double")) {
            return "DOUBLE";
        }
        if (type.equals("Timestamp")) {
            return "TIMESTAMP";
        }
        return "VARCHAR(256)";
    }

    @Override
    public void dropTable(Object connectionHandle, String table) throws DataSourceException {
        StringBuffer sqlString = new StringBuffer();
        sqlString.append("DROP TABLE ");
        sqlString.append(table);
        this.executeUpdateSQL(connectionHandle, sqlString.toString(), false);
    }

    @Override
    public void insert(Object connectionHandle, Record record, String table, boolean trxStarted) throws DataSourceException {
        String sql = this.makeInsertString(record, table);
        if (this.outSql) {
            AlinousDebug.println(sql);
        }
        this.executeUpdateSQL(connectionHandle, sql, trxStarted);
    }

    private String makeInsertString(Record record, String table) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        sql.append(table);
        sql.append(" (");
        boolean first = true;
        for (String field : record.getMap().keySet()) {
            if (first) {
                first = false;
            } else {
                sql.append(", ");
            }
            sql.append(field);
        }
        sql.append(")");
        sql.append(" VALUES ");
        this.outRecordValue(record, sql);
        sql.append(";");
        return sql.toString();
    }

    @Override
    public void insert(Object connectionHandle, List<Record> records, String table, boolean trxStarted) throws DataSourceException {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        sql.append(table);
        sql.append(" (");
        boolean first = true;
        for (String field : records.get(0).getMap().keySet()) {
            if (first) {
                first = false;
            } else {
                sql.append(", ");
            }
            sql.append(field);
        }
        sql.append(")");
        sql.append(" VALUES ");
        first = true;
        for (Record rec : records) {
            StringBuffer eachSql = new StringBuffer(sql);
            this.outRecordValue(rec, eachSql);
            this.executeUpdateSQL(connectionHandle, eachSql.toString(), trxStarted);
        }
    }

    @Override
    public void insert(Object connectionHandle, ColumnList cols, ArrayList<VariableList> valueLists, String table, boolean trxStarted) throws DataSourceException, ExecutionException {
        boolean first;
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        sql.append(table);
        if (cols != null && cols.isReady()) {
            sql.append(" ( ");
            first = true;
            Iterator<SelectColumnElement> it = cols.iterator();
            while (it.hasNext()) {
                SelectColumnElement element = it.next();
                if (first) {
                    first = false;
                } else {
                    sql.append(", ");
                }
                sql.append(element.extract());
            }
            sql.append(" ) ");
        }
        sql.append("VALUES ");
        first = true;
        for (VariableList valList : valueLists) {
            if (first) {
                first = false;
            } else {
                sql.append(", ");
            }
            sql.append(valList.extract());
        }
        if (this.outSql) {
            AlinousDebug.debugOut(sql.toString());
        }
        this.executeUpdateSQL(connectionHandle, sql.toString(), trxStarted);
    }

    private void outRecordValue(Record record, StringBuffer sql) {
        sql.append("(");
        boolean first = true;
        Map<String, String> map = record.getMap();
        Iterator<String> it = map.keySet().iterator();
        while (it.hasNext()) {
            if (first) {
                first = false;
            } else {
                sql.append(", ");
            }
            String val = map.get(it.next());
            if (val != null) {
                sql.append("'");
                sql.append(val);
                sql.append("'");
                continue;
            }
            sql.append("NULL");
        }
        sql.append(")");
    }

    @Override
    public void delete(Object connectionHandle, String fromStr, WhereClause where, boolean trxStarted) throws DataSourceException, ExecutionException {
        StringBuffer sql = new StringBuffer();
        sql.append("DELETE ");
        sql.append(fromStr);
        if (where != null && where.isReady()) {
            sql.append(" ");
            sql.append(where.extract());
        }
        if (this.outSql) {
            AlinousDebug.debugOut(sql.toString());
        }
        this.executeUpdateSQL(connectionHandle, sql.toString(), trxStarted);
    }

    @Override
    public void update(Object connectionHandle, String table, SetClause set, WhereClause where, boolean trxStarted) throws DataSourceException, ExecutionException {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE ");
        sql.append(table);
        if (set != null && set.isReady()) {
            sql.append(" ");
            sql.append(set.extract());
        }
        if (where != null && where.isReady()) {
            sql.append(" ");
            sql.append(where.extract());
        }
        if (this.outSql) {
            AlinousDebug.debugOut(sql.toString());
        }
        this.executeUpdateSQL(connectionHandle, sql.toString(), trxStarted);
    }

    @Override
    public void executeUpdateSQL(Object connectionHandle, String sql, boolean trxStarted) throws DataSourceException {
        Connection con = (Connection)connectionHandle;
        if (trxStarted) {
            try {
                this.executeAddBatch(con, sql);
            }
            catch (SQLException e) {
                throw new DataSourceException(e);
            }
            return;
        }
        try {
            Statement stmt = con.createStatement();
            stmt.executeUpdate(sql);
        }
        catch (SQLException e) {
            throw new DataSourceException(e);
        }
    }

    private void executeAddBatch(Connection con, String sql) throws SQLException {
        Statement batchStmt = this.batchedStatementMap.get(con);
        if (batchStmt == null) {
            batchStmt = con.createStatement();
            this.batchedStatementMap.put(con, batchStmt);
        }
        batchStmt.addBatch(sql);
    }

    @Override
    public DataTable getDataTable(Object connectionHandle, String tableName) throws DataSourceException {
        DatabaseMetaData metaData;
        DataTable dataTable = null;
        Connection con = (Connection)connectionHandle;
        ResultSet rsSet = null;
        try {
            metaData = con.getMetaData();
            rsSet = metaData.getTables(null, null, "%", new String[]{"TABLE"});
        }
        catch (SQLException e) {
            throw new DataSourceException(e);
        }
        try {
            while (rsSet.next()) {
                String tbl = rsSet.getString("TABLE_NAME");
                if (!tableName.equals(tbl.toUpperCase())) continue;
                dataTable = new DataTable();
                this.setupDataTableColumns(metaData, dataTable, tableName);
            }
        }
        catch (SQLException e) {
            throw new DataSourceException(e);
        }
        finally {
            try {
                rsSet.close();
            }
            catch (SQLException ignore) {}
        }
        return dataTable;
    }

    private void setupDataTableColumns(DatabaseMetaData metaData, DataTable dataTable, String tableName) throws SQLException {
        ResultSet trs = metaData.getColumns(null, null, tableName, null);
        while (trs.next()) {
            String columnName = trs.getString("COLUMN_NAME");
            String columnType = trs.getString("TYPE_NAME");
            DataField fld = new DataField();
            fld.setName(columnName);
            if (columnType.equals("VARCHAR")) {
                fld.setType("String");
            }
            dataTable.addField(fld);
        }
    }

    @Override
    public List<Record> select(Object connectionHandle, SelectColumns columns, FromClause from, WhereClause where, GroupByClause groupBy, OrderByClause orderBy, LimitOffsetClause limit, ForUpdateClause forupdate) throws DataSourceException, ExecutionException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        sql.append(columns.extract());
        sql.append(" ");
        sql.append(from.extract());
        if (where != null && where.isReady()) {
            sql.append(" ");
            sql.append(where.extract());
        }
        if (groupBy != null && groupBy.isReady()) {
            sql.append(" ");
            sql.append(groupBy.extract());
        }
        if (orderBy != null && orderBy.isReady()) {
            sql.append(" ");
            sql.append(orderBy.extract());
        }
        if (forupdate != null && forupdate.isReady()) {
            sql.append(" ");
            sql.append(forupdate.extract());
        }
        if (this.outSql) {
            AlinousDebug.debugOut(sql.toString());
        }
        List<Record> tmp = this.executeSelectSQL(connectionHandle, sql.toString(), limit);
        return tmp;
    }

    private List<Record> executeSelectSQL(Object connectionHandle, String sql, LimitOffsetClause limit) throws DataSourceException, ExecutionException {
        Connection con = (Connection)connectionHandle;
        Statement stmt = null;
        LinkedList<Record> retList = new LinkedList<Record>();
        try {
            stmt = con.createStatement(1005, 1007);
            stmt.execute(sql);
            ResultSet rs = stmt.getResultSet();
            ResultSetMetaData metaData = rs.getMetaData();
            if (limit != null && limit.isReady()) {
                this.fetchWithOffset(rs, metaData, retList, limit);
            } else {
                while (rs.next()) {
                    int cnt = metaData.getColumnCount();
                    Record rec = new Record();
                    for (int i = 0; i < cnt; ++i) {
                        String colName = metaData.getColumnName(i + 1).toUpperCase();
                        String value = rs.getString(i + 1);
                        rec.addFieldValue(colName, value);
                    }
                    retList.add(rec);
                }
            }
        }
        catch (SQLException e) {
            throw new DataSourceException(e);
        }
        finally {
            try {
                stmt.close();
            }
            catch (SQLException ignore) {}
        }
        return retList;
    }

    private void fetchWithOffset(ResultSet rs, ResultSetMetaData metaData, List<Record> retList, LimitOffsetClause limit) throws ExecutionException, SQLException {
        String str;
        ISQLStatement limitStmt = limit.getLimit();
        ISQLStatement offsetStmt = limit.getOffset();
        int nLimit = 0;
        int nOffset = 0;
        if (limitStmt != null && limitStmt.isReady()) {
            str = limitStmt.extract();
            nLimit = Integer.parseInt(str);
        }
        if (offsetStmt != null && offsetStmt.isReady()) {
            str = offsetStmt.extract();
            nOffset = Integer.parseInt(str);
        }
        if (offsetStmt != null) {
            rs.absolute(nOffset);
        }
        int count = 0;
        while (rs.next() && count < nLimit) {
            ++count;
            int cnt = metaData.getColumnCount();
            Record rec = new Record();
            for (int i = 0; i < cnt; ++i) {
                String colName = metaData.getColumnName(i + 1).toUpperCase();
                String value = rs.getString(i + 1);
                rec.addFieldValue(colName, value);
            }
            retList.add(rec);
        }
    }

    @Override
    public void setLogger(ILogProvidor logger) {
        this.logger = logger;
    }

    @Override
    public void setOutSql(boolean outSql) {
        this.outSql = outSql;
    }

    @Override
    public void setPass(String pass) {
        this.pass = pass;
    }

    @Override
    public void setUri(String uri) {
        this.uri = uri;
    }

    @Override
    public void setUser(String user) {
        this.user = user;
    }
}

