/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.repository;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import org.alinous.AlinousCore;
import org.alinous.AlinousUtils;
import org.alinous.exec.pages.AlinousExecutableModule;
import org.alinous.expections.AlinousException;
import org.alinous.expections.CompileError;
import org.alinous.expections.ModuleNotFoundException;
import org.alinous.objects.html.AlinousTopObject;
import org.alinous.parser.object.AlinousObjectParser;
import org.alinous.parser.script.AlinousScriptParser;
import org.alinous.parser.script.ParseException;
import org.alinous.parser.xml.AlinousXmlObjectParser;
import org.alinous.repository.AlinousModule;
import org.alinous.script.AlinousScript;

public class AlinousModuleRepository {
    private Hashtable<String, AlinousModule> alinousObjects = new Hashtable();
    private AlinousCore alinousCore;

    public AlinousModuleRepository(AlinousCore core) {
        this.alinousCore = core;
    }

    public void registerAlinousModule(String dsPath, String acPath) throws AlinousException {
        long timeStamp;
        String moduleName = AlinousUtils.getModuleName(dsPath);
        AlinousModule mod = this.alinousObjects.get(moduleName);
        File dsfile = this.getDesingFile(moduleName);
        File acfile = new File(AlinousUtils.getAbsolutePath(this.alinousCore.getHome(), acPath));
        long l = timeStamp = dsfile.lastModified() > acfile.lastModified() ? dsfile.lastModified() : acfile.lastModified();
        if (timeStamp == 0L) {
            throw new ModuleNotFoundException(AlinousUtils.getModuleName(dsPath));
        }
        if (mod != null && timeStamp <= mod.getLastModified()) {
            return;
        }
        if (mod != null) {
            this.alinousObjects.remove(mod);
        }
        if (dsfile.getPath().endsWith(".html")) {
            dsPath = moduleName + ".html";
        } else if (dsfile.getPath().endsWith(".rss")) {
            dsPath = moduleName + ".rss";
        }
        AlinousTopObject design = this.parseDesign(dsPath);
        AlinousScript script = this.parseScript(acPath);
        if (design == null && script == null) {
            throw new ModuleNotFoundException(AlinousUtils.getModuleName(dsPath));
        }
        mod = new AlinousModule(acPath, design, script, timeStamp);
        this.alinousObjects.put(moduleName, mod);
    }

    private File getDesingFile(String moduleName) {
        String fileName = AlinousUtils.getAbsolutePath(this.alinousCore.getHome(), moduleName + ".html");
        File file = new File(fileName);
        if (file.exists()) {
            return file;
        }
        fileName = AlinousUtils.getAbsolutePath(this.alinousCore.getHome(), moduleName + ".rss");
        file = new File(fileName);
        if (file.exists()) {
            return file;
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AlinousTopObject parseDesign(String path) throws AlinousException {
        FileInputStream stream;
        String fullPath = AlinousUtils.getAbsolutePath(this.alinousCore.getHome(), path);
        File file = new File(fullPath);
        if (!file.exists()) {
            return null;
        }
        try {
            stream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new AlinousException(e, "File I/O Error");
        }
        AlinousTopObject topObj = null;
        try {
            topObj = this.parseAlinosObject(stream, fullPath);
            path = AlinousUtils.getNotOSPath(path);
            topObj.setPath(AlinousUtils.formatAbsolute(path));
        }
        finally {
            try {
                ((InputStream)stream).close();
            }
            catch (IOException e) {}
        }
        return topObj;
    }

    private AlinousScript parseScript(String path) throws AlinousException {
        FileInputStream stream;
        String fullPath = AlinousUtils.getAbsolutePath(this.alinousCore.getHome(), path);
        File file = new File(fullPath);
        if (!file.exists()) {
            return null;
        }
        try {
            stream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new AlinousException(e, "File I/O Error");
        }
        AlinousScript scriptObj = null;
        path = AlinousUtils.getNotOSPath(path);
        scriptObj = this.parseScriptObject(stream, AlinousUtils.formatAbsolute(path));
        return scriptObj;
    }

    private AlinousScript parseScriptObject(InputStream stream, String filePath) throws AlinousException {
        AlinousScript scriptObj;
        InputStreamReader reader;
        try {
            reader = new InputStreamReader(stream, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AlinousException(e, "UTF-8 is not supported");
        }
        AlinousScriptParser parser = new AlinousScriptParser(reader);
        parser.setFilePath(AlinousUtils.getNotOSPath(filePath));
        try {
            scriptObj = parser.parse();
        }
        catch (ParseException e) {
            throw new CompileError(e, "Compile Error");
        }
        return scriptObj;
    }

    private AlinousTopObject parseAlinosObject(InputStream stream, String fullPath) throws AlinousException {
        AlinousTopObject topObj;
        InputStreamReader reader;
        try {
            reader = new InputStreamReader(stream, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AlinousException(e, "UTF-8 is not supported");
        }
        if (fullPath.endsWith(".html")) {
            AlinousObjectParser parser = new AlinousObjectParser(reader);
            try {
                topObj = parser.parse();
            }
            catch (org.alinous.parser.object.ParseException e) {
                throw new CompileError(e, "Compile Error");
            }
        }
        AlinousXmlObjectParser parser = new AlinousXmlObjectParser(reader);
        try {
            topObj = parser.parse();
        }
        catch (org.alinous.parser.xml.ParseException e) {
            throw new CompileError(e, "Compile Error");
        }
        return topObj;
    }

    public AlinousModule getModule(String path) {
        return this.alinousObjects.get(path);
    }

    public AlinousExecutableModule loadExecutableModule(String key) throws AlinousException {
        AlinousModule module = this.alinousObjects.get(key);
        if (module == null) {
            return null;
        }
        return module.fork();
    }
}

