/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.script.basic;

import org.alinous.debug.StepInCandidates;
import org.alinous.exec.pages.PostContext;
import org.alinous.expections.AlinousException;
import org.alinous.expections.ExecutionException;
import org.alinous.script.IScriptSentence;
import org.alinous.script.basic.condition.IScriptCondition;
import org.alinous.script.basic.condition.JDomConditionFactory;
import org.alinous.script.runtime.IScriptVariable;
import org.alinous.script.runtime.VariableRepository;
import org.jdom.Content;
import org.jdom.Element;

public class DummyConditionSentence
implements IScriptSentence {
    public static final String ATTR_LINE = "line";
    public static final String ATTR_LINE_POSITION = "linePosition";
    private int line;
    private int linePosition;
    private String filePath;
    private IScriptCondition condition;

    public DummyConditionSentence() {
    }

    public DummyConditionSentence(IScriptSentence sentence) {
        this.line = sentence.getLine();
        this.linePosition = sentence.getLinePosition();
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public int getLinePosition() {
        return this.linePosition;
    }

    public void setLinePosition(int linePosition) {
        this.linePosition = linePosition;
    }

    public StepInCandidates getStepInCandidates() {
        StepInCandidates candidates = new StepInCandidates();
        this.condition.canStepInStatements(candidates);
        return candidates;
    }

    public boolean execute(PostContext context, VariableRepository valRepo) throws ExecutionException {
        return true;
    }

    public void exportIntoJDomElement(Element parent) throws AlinousException {
        Element sentenceElement = new Element("EXECUTABLE");
        sentenceElement.setAttribute("execClass", this.getClass().getName());
        sentenceElement.setAttribute(ATTR_LINE, Integer.toString(this.line));
        sentenceElement.setAttribute(ATTR_LINE_POSITION, Integer.toString(this.linePosition));
        parent.addContent((Content)sentenceElement);
        if (this.condition != null) {
            this.condition.exportIntoJDomElement(sentenceElement);
        }
    }

    public void importFromJDomElement(Element element) throws AlinousException {
        String strLinePosition;
        String strLine = element.getAttributeValue(ATTR_LINE);
        if (strLine != null) {
            this.line = Integer.parseInt(strLine);
        }
        if ((strLinePosition = element.getAttributeValue(ATTR_LINE_POSITION)) != null) {
            this.linePosition = Integer.parseInt(strLinePosition);
        }
        Element cond = element.getChild("CONDITION");
        this.condition = JDomConditionFactory.createConditionFromJDomElement(cond);
        this.condition.importFromJDomElement(cond);
    }

    public IScriptCondition getCondition() {
        return this.condition;
    }

    public void setCondition(IScriptCondition condition) {
        this.condition = condition;
        condition.setCallerSentence(this);
    }

    public IScriptVariable getReturnedVariable() {
        return null;
    }
}

